/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stats;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stats.GetMessagePublicForwards;

public final class ImmutableGetMessagePublicForwards
implements GetMessagePublicForwards {
    private final int identifier;
    private final InputChannel channel;
    private final int msgId;
    private final int offsetRate;
    private final InputPeer offsetPeer;
    private final int offsetId;
    private final int limit;

    private ImmutableGetMessagePublicForwards(InputChannel channel, int msgId, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.msgId = msgId;
        this.offsetRate = offsetRate;
        this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
        this.offsetId = offsetId;
        this.limit = limit;
        this.identifier = GetMessagePublicForwards.super.identifier();
    }

    private ImmutableGetMessagePublicForwards(Builder builder) {
        this.channel = builder.channel;
        this.msgId = builder.msgId;
        this.offsetRate = builder.offsetRate;
        this.offsetPeer = builder.offsetPeer;
        this.offsetId = builder.offsetId;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetMessagePublicForwards.super.identifier();
    }

    private ImmutableGetMessagePublicForwards(int identifier, InputChannel channel, int msgId, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        this.identifier = identifier;
        this.channel = channel;
        this.msgId = msgId;
        this.offsetRate = offsetRate;
        this.offsetPeer = offsetPeer;
        this.offsetId = offsetId;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public int offsetRate() {
        return this.offsetRate;
    }

    @Override
    public InputPeer offsetPeer() {
        return this.offsetPeer;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetMessagePublicForwards withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMessagePublicForwards(value, this.channel, this.msgId, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetMessagePublicForwards(this.identifier, newValue, this.msgId, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableGetMessagePublicForwards(this.identifier, this.channel, value, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withOffsetRate(int value) {
        if (this.offsetRate == value) {
            return this;
        }
        return new ImmutableGetMessagePublicForwards(this.identifier, this.channel, this.msgId, value, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withOffsetPeer(InputPeer value) {
        if (this.offsetPeer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "offsetPeer");
        return new ImmutableGetMessagePublicForwards(this.identifier, this.channel, this.msgId, this.offsetRate, newValue, this.offsetId, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetMessagePublicForwards(this.identifier, this.channel, this.msgId, this.offsetRate, this.offsetPeer, value, this.limit);
    }

    public final ImmutableGetMessagePublicForwards withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetMessagePublicForwards(this.identifier, this.channel, this.msgId, this.offsetRate, this.offsetPeer, this.offsetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMessagePublicForwards && this.equalTo(0, (ImmutableGetMessagePublicForwards)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMessagePublicForwards another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.msgId == another.msgId && this.offsetRate == another.offsetRate && this.offsetPeer.equals(another.offsetPeer) && this.offsetId == another.offsetId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.offsetRate;
        h += (h << 5) + this.offsetPeer.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetMessagePublicForwards{identifier=" + this.identifier + ", channel=" + this.channel + ", msgId=" + this.msgId + ", offsetRate=" + this.offsetRate + ", offsetPeer=" + this.offsetPeer + ", offsetId=" + this.offsetId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetMessagePublicForwards of(InputChannel channel, int msgId, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        return new ImmutableGetMessagePublicForwards(channel, msgId, offsetRate, offsetPeer, offsetId, limit);
    }

    public static ImmutableGetMessagePublicForwards copyOf(GetMessagePublicForwards instance) {
        if (instance instanceof ImmutableGetMessagePublicForwards) {
            return (ImmutableGetMessagePublicForwards)instance;
        }
        return ImmutableGetMessagePublicForwards.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_OFFSET_RATE = 4L;
        private static final long INIT_BIT_OFFSET_PEER = 8L;
        private static final long INIT_BIT_OFFSET_ID = 16L;
        private static final long INIT_BIT_LIMIT = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private int msgId;
        private int offsetRate;
        private InputPeer offsetPeer;
        private int offsetId;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetMessagePublicForwards instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetMessagePublicForwards instance;
            long bits = 0L;
            if (object instanceof GetMessagePublicForwards) {
                instance = (GetMessagePublicForwards)object;
                this.offsetRate(instance.offsetRate());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offsetPeer(instance.offsetPeer());
                this.channel(instance.channel());
                this.limit(instance.limit());
                this.msgId(instance.msgId());
                this.offsetId(instance.offsetId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetRate(int offsetRate) {
            this.offsetRate = offsetRate;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offsetPeer(InputPeer offsetPeer) {
            this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableGetMessagePublicForwards build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetMessagePublicForwards(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetRate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offsetPeer");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetMessagePublicForwards, some of required attributes are not set " + attributes;
        }
    }
}

