/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stats;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stats.GetMessageStats;

public final class ImmutableGetMessageStats
implements GetMessageStats {
    private final int identifier;
    private final int flags;
    private final boolean dark;
    private final InputChannel channel;
    private final int msgId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetMessageStats(InputChannel channel, int msgId) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.msgId = msgId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableGetMessageStats(Builder builder) {
        this.channel = builder.channel;
        this.msgId = builder.msgId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.darkIsSet()) {
            this.initShim.dark(builder.dark);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableGetMessageStats(int identifier, int flags, boolean dark, InputChannel channel, int msgId) {
        this.identifier = identifier;
        this.flags = flags;
        this.dark = dark;
        this.channel = channel;
        this.msgId = msgId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetMessageStats.super.identifier();
    }

    private int flagsInitialize() {
        return GetMessageStats.super.flags();
    }

    private boolean darkInitialize() {
        return GetMessageStats.super.dark();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean dark() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dark() : this.dark;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    public final ImmutableGetMessageStats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMessageStats(value, this.flags, this.dark, this.channel, this.msgId);
    }

    public final ImmutableGetMessageStats withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetMessageStats(this.identifier, value, this.dark, this.channel, this.msgId);
    }

    public final ImmutableGetMessageStats withDark(boolean value) {
        if (this.dark == value) {
            return this;
        }
        return new ImmutableGetMessageStats(this.identifier, this.flags, value, this.channel, this.msgId);
    }

    public final ImmutableGetMessageStats withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetMessageStats(this.identifier, this.flags, this.dark, newValue, this.msgId);
    }

    public final ImmutableGetMessageStats withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableGetMessageStats(this.identifier, this.flags, this.dark, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMessageStats && this.equalTo(0, (ImmutableGetMessageStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMessageStats another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.dark == another.dark && this.channel.equals(another.channel) && this.msgId == another.msgId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.dark);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.msgId;
        return h;
    }

    public String toString() {
        return "GetMessageStats{identifier=" + this.identifier + ", flags=" + this.flags + ", dark=" + this.dark + ", channel=" + this.channel + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableGetMessageStats of(InputChannel channel, int msgId) {
        return new ImmutableGetMessageStats(channel, msgId);
    }

    public static ImmutableGetMessageStats copyOf(GetMessageStats instance) {
        if (instance instanceof ImmutableGetMessageStats) {
            return (ImmutableGetMessageStats)instance;
        }
        return ImmutableGetMessageStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_DARK = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean dark;
        private InputChannel channel;
        private int msgId;

        private Builder() {
        }

        public final Builder from(GetMessageStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetMessageStats instance;
            long bits = 0L;
            if (object instanceof GetMessageStats) {
                instance = (GetMessageStats)object;
                this.flags(instance.flags());
                this.dark(instance.dark());
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder dark(boolean dark) {
            this.dark = dark;
            this.optBits |= 4L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetMessageStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetMessageStats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean darkIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build GetMessageStats, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte darkBuildStage = 0;
        private boolean dark;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetMessageStats.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetMessageStats.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean dark() {
            if (this.darkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.darkBuildStage == 0) {
                this.darkBuildStage = (byte)-1;
                this.dark = ImmutableGetMessageStats.this.darkInitialize();
                this.darkBuildStage = 1;
            }
            return this.dark;
        }

        void dark(boolean dark) {
            this.dark = dark;
            this.darkBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.darkBuildStage == -1) {
                attributes.add("dark");
            }
            return "Cannot build GetMessageStats, attribute initializers form cycle " + attributes;
        }
    }
}

