/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stats;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stats.LoadAsyncGraph;

public final class ImmutableLoadAsyncGraph
implements LoadAsyncGraph {
    private final int identifier;
    private final int flags;
    private final String token;
    @Nullable
    private final Long x;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLoadAsyncGraph(String token) {
        this.token = Objects.requireNonNull(token, "token");
        this.x = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLoadAsyncGraph(Builder builder) {
        this.token = builder.token;
        this.x = builder.x;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLoadAsyncGraph(int identifier, int flags, String token, @Nullable Long x) {
        this.identifier = identifier;
        this.flags = flags;
        this.token = token;
        this.x = x;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return LoadAsyncGraph.super.identifier();
    }

    private int flagsInitialize() {
        return LoadAsyncGraph.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    @Nullable
    public Long x() {
        return this.x;
    }

    public final ImmutableLoadAsyncGraph withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLoadAsyncGraph(value, this.flags, this.token, this.x);
    }

    public final ImmutableLoadAsyncGraph withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableLoadAsyncGraph(this.identifier, value, this.token, this.x);
    }

    public final ImmutableLoadAsyncGraph withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableLoadAsyncGraph(this.identifier, this.flags, newValue, this.x);
    }

    public final ImmutableLoadAsyncGraph withX(@Nullable Long value) {
        if (Objects.equals(this.x, value)) {
            return this;
        }
        return new ImmutableLoadAsyncGraph(this.identifier, this.flags, this.token, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoadAsyncGraph && this.equalTo(0, (ImmutableLoadAsyncGraph)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoadAsyncGraph another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.token.equals(another.token) && Objects.equals(this.x, another.x);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + Objects.hashCode(this.x);
        return h;
    }

    public String toString() {
        return "LoadAsyncGraph{identifier=" + this.identifier + ", flags=" + this.flags + ", token=" + this.token + ", x=" + this.x + "}";
    }

    public static ImmutableLoadAsyncGraph of(String token) {
        return new ImmutableLoadAsyncGraph(token);
    }

    public static ImmutableLoadAsyncGraph copyOf(LoadAsyncGraph instance) {
        if (instance instanceof ImmutableLoadAsyncGraph) {
            return (ImmutableLoadAsyncGraph)instance;
        }
        return ImmutableLoadAsyncGraph.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String token;
        private Long x;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LoadAsyncGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof LoadAsyncGraph) {
                instance = (LoadAsyncGraph)object;
                this.flags(instance.flags());
                Long xValue = instance.x();
                if (xValue != null) {
                    this.x(xValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.token(instance.token());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder x(@Nullable Long x) {
            this.x = x;
            return this;
        }

        public ImmutableLoadAsyncGraph build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoadAsyncGraph(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build LoadAsyncGraph, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableLoadAsyncGraph.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableLoadAsyncGraph.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build LoadAsyncGraph, attribute initializers form cycle " + attributes;
        }
    }
}

