/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stickers;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetItem;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stickers.AddStickerToSet;

public final class ImmutableAddStickerToSet
implements AddStickerToSet {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final InputStickerSetItem sticker;

    private ImmutableAddStickerToSet(InputStickerSet stickerset, InputStickerSetItem sticker) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.sticker = Objects.requireNonNull(sticker, "sticker");
        this.identifier = AddStickerToSet.super.identifier();
    }

    private ImmutableAddStickerToSet(Builder builder) {
        this.stickerset = builder.stickerset;
        this.sticker = builder.sticker;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AddStickerToSet.super.identifier();
    }

    private ImmutableAddStickerToSet(int identifier, InputStickerSet stickerset, InputStickerSetItem sticker) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.sticker = sticker;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public InputStickerSetItem sticker() {
        return this.sticker;
    }

    public final ImmutableAddStickerToSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAddStickerToSet(value, this.stickerset, this.sticker);
    }

    public final ImmutableAddStickerToSet withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableAddStickerToSet(this.identifier, newValue, this.sticker);
    }

    public final ImmutableAddStickerToSet withSticker(InputStickerSetItem value) {
        if (this.sticker == value) {
            return this;
        }
        InputStickerSetItem newValue = Objects.requireNonNull(value, "sticker");
        return new ImmutableAddStickerToSet(this.identifier, this.stickerset, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddStickerToSet && this.equalTo(0, (ImmutableAddStickerToSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableAddStickerToSet another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.sticker.equals(another.sticker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + this.sticker.hashCode();
        return h;
    }

    public String toString() {
        return "AddStickerToSet{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", sticker=" + this.sticker + "}";
    }

    public static ImmutableAddStickerToSet of(InputStickerSet stickerset, InputStickerSetItem sticker) {
        return new ImmutableAddStickerToSet(stickerset, sticker);
    }

    public static ImmutableAddStickerToSet copyOf(AddStickerToSet instance) {
        if (instance instanceof ImmutableAddStickerToSet) {
            return (ImmutableAddStickerToSet)instance;
        }
        return ImmutableAddStickerToSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_STICKER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private InputStickerSetItem sticker;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AddStickerToSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AddStickerToSet) {
                instance = (AddStickerToSet)object;
                this.sticker(instance.sticker());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sticker(InputStickerSetItem sticker) {
            this.sticker = Objects.requireNonNull(sticker, "sticker");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAddStickerToSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddStickerToSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sticker");
            }
            return "Cannot build AddStickerToSet, some of required attributes are not set " + attributes;
        }
    }
}

