/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stickers;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stickers.ChangeStickerPosition;

public final class ImmutableChangeStickerPosition
implements ChangeStickerPosition {
    private final int identifier;
    private final InputDocument sticker;
    private final int position;

    private ImmutableChangeStickerPosition(InputDocument sticker, int position) {
        this.sticker = Objects.requireNonNull(sticker, "sticker");
        this.position = position;
        this.identifier = ChangeStickerPosition.super.identifier();
    }

    private ImmutableChangeStickerPosition(Builder builder) {
        this.sticker = builder.sticker;
        this.position = builder.position;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChangeStickerPosition.super.identifier();
    }

    private ImmutableChangeStickerPosition(int identifier, InputDocument sticker, int position) {
        this.identifier = identifier;
        this.sticker = sticker;
        this.position = position;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument sticker() {
        return this.sticker;
    }

    @Override
    public int position() {
        return this.position;
    }

    public final ImmutableChangeStickerPosition withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChangeStickerPosition(value, this.sticker, this.position);
    }

    public final ImmutableChangeStickerPosition withSticker(InputDocument value) {
        if (this.sticker == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "sticker");
        return new ImmutableChangeStickerPosition(this.identifier, newValue, this.position);
    }

    public final ImmutableChangeStickerPosition withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableChangeStickerPosition(this.identifier, this.sticker, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChangeStickerPosition && this.equalTo(0, (ImmutableChangeStickerPosition)another);
    }

    private boolean equalTo(int synthetic, ImmutableChangeStickerPosition another) {
        return this.identifier == another.identifier && this.sticker.equals(another.sticker) && this.position == another.position;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.sticker.hashCode();
        h += (h << 5) + this.position;
        return h;
    }

    public String toString() {
        return "ChangeStickerPosition{identifier=" + this.identifier + ", sticker=" + this.sticker + ", position=" + this.position + "}";
    }

    public static ImmutableChangeStickerPosition of(InputDocument sticker, int position) {
        return new ImmutableChangeStickerPosition(sticker, position);
    }

    public static ImmutableChangeStickerPosition copyOf(ChangeStickerPosition instance) {
        if (instance instanceof ImmutableChangeStickerPosition) {
            return (ImmutableChangeStickerPosition)instance;
        }
        return ImmutableChangeStickerPosition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKER = 1L;
        private static final long INIT_BIT_POSITION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputDocument sticker;
        private int position;

        private Builder() {
        }

        public final Builder from(ChangeStickerPosition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChangeStickerPosition instance;
            long bits = 0L;
            if (object instanceof ChangeStickerPosition) {
                instance = (ChangeStickerPosition)object;
                this.sticker(instance.sticker());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.position(instance.position());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sticker(InputDocument sticker) {
            this.sticker = Objects.requireNonNull(sticker, "sticker");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChangeStickerPosition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChangeStickerPosition(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sticker");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("position");
            }
            return "Cannot build ChangeStickerPosition, some of required attributes are not set " + attributes;
        }
    }
}

