/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stickers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputStickerSetItem;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stickers.CreateStickerSet;

public final class ImmutableCreateStickerSet
implements CreateStickerSet {
    private final int identifier;
    private final int flags;
    private final boolean masks;
    private final boolean animated;
    private final boolean videos;
    private final InputUser userId;
    private final String title;
    private final String shortName;
    @Nullable
    private final InputDocument thumb;
    private final List<InputStickerSetItem> stickers;
    @Nullable
    private final String software;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCreateStickerSet(InputUser userId, String title, String shortName) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.title = Objects.requireNonNull(title, "title");
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.thumb = null;
        this.stickers = Collections.emptyList();
        this.software = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.masks = this.initShim.masks();
        this.animated = this.initShim.animated();
        this.videos = this.initShim.videos();
        this.initShim = null;
    }

    private ImmutableCreateStickerSet(Builder builder) {
        this.userId = builder.userId;
        this.title = builder.title;
        this.shortName = builder.shortName;
        this.thumb = builder.thumb;
        this.stickers = ImmutableCreateStickerSet.createUnmodifiableList(true, builder.stickers);
        this.software = builder.software;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.masksIsSet()) {
            this.initShim.masks(builder.masks);
        }
        if (builder.animatedIsSet()) {
            this.initShim.animated(builder.animated);
        }
        if (builder.videosIsSet()) {
            this.initShim.videos(builder.videos);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.masks = this.initShim.masks();
        this.animated = this.initShim.animated();
        this.videos = this.initShim.videos();
        this.initShim = null;
    }

    private ImmutableCreateStickerSet(int identifier, int flags, boolean masks, boolean animated, boolean videos, InputUser userId, String title, String shortName, @Nullable InputDocument thumb, List<InputStickerSetItem> stickers, @Nullable String software) {
        this.identifier = identifier;
        this.flags = flags;
        this.masks = masks;
        this.animated = animated;
        this.videos = videos;
        this.userId = userId;
        this.title = title;
        this.shortName = shortName;
        this.thumb = thumb;
        this.stickers = stickers;
        this.software = software;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CreateStickerSet.super.identifier();
    }

    private int flagsInitialize() {
        return CreateStickerSet.super.flags();
    }

    private boolean masksInitialize() {
        return CreateStickerSet.super.masks();
    }

    private boolean animatedInitialize() {
        return CreateStickerSet.super.animated();
    }

    private boolean videosInitialize() {
        return CreateStickerSet.super.videos();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean masks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.masks() : this.masks;
    }

    @Override
    public boolean animated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.animated() : this.animated;
    }

    @Override
    public boolean videos() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videos() : this.videos;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    @Nullable
    public InputDocument thumb() {
        return this.thumb;
    }

    @Override
    public List<InputStickerSetItem> stickers() {
        return this.stickers;
    }

    @Override
    @Nullable
    public String software() {
        return this.software;
    }

    public final ImmutableCreateStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(value, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, value, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withMasks(boolean value) {
        if (this.masks == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, value, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withAnimated(boolean value) {
        if (this.animated == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, value, this.videos, this.userId, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withVideos(boolean value) {
        if (this.videos == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, value, this.userId, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, newValue, this.title, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, newValue, this.shortName, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, newValue, this.thumb, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withThumb(@Nullable InputDocument value) {
        if (this.thumb == value) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, value, this.stickers, this.software);
    }

    public final ImmutableCreateStickerSet withStickers(InputStickerSetItem ... elements) {
        List<InputStickerSetItem> newValue = ImmutableCreateStickerSet.createUnmodifiableList(false, ImmutableCreateStickerSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, newValue, this.software);
    }

    public final ImmutableCreateStickerSet withStickers(Iterable<? extends InputStickerSetItem> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<InputStickerSetItem> newValue = ImmutableCreateStickerSet.createUnmodifiableList(false, ImmutableCreateStickerSet.createSafeList(elements, true, false));
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, newValue, this.software);
    }

    public final ImmutableCreateStickerSet withSoftware(@Nullable String value) {
        if (Objects.equals(this.software, value)) {
            return this;
        }
        return new ImmutableCreateStickerSet(this.identifier, this.flags, this.masks, this.animated, this.videos, this.userId, this.title, this.shortName, this.thumb, this.stickers, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateStickerSet && this.equalTo(0, (ImmutableCreateStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateStickerSet another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.masks == another.masks && this.animated == another.animated && this.videos == another.videos && this.userId.equals(another.userId) && this.title.equals(another.title) && this.shortName.equals(another.shortName) && Objects.equals(this.thumb, another.thumb) && this.stickers.equals(another.stickers) && Objects.equals(this.software, another.software);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.masks);
        h += (h << 5) + Boolean.hashCode(this.animated);
        h += (h << 5) + Boolean.hashCode(this.videos);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.shortName.hashCode();
        h += (h << 5) + Objects.hashCode(this.thumb);
        h += (h << 5) + this.stickers.hashCode();
        h += (h << 5) + Objects.hashCode(this.software);
        return h;
    }

    public String toString() {
        return "CreateStickerSet{identifier=" + this.identifier + ", flags=" + this.flags + ", masks=" + this.masks + ", animated=" + this.animated + ", videos=" + this.videos + ", userId=" + this.userId + ", title=" + this.title + ", shortName=" + this.shortName + ", thumb=" + this.thumb + ", stickers=" + this.stickers + ", software=" + this.software + "}";
    }

    public static ImmutableCreateStickerSet of(InputUser userId, String title, String shortName) {
        return new ImmutableCreateStickerSet(userId, title, shortName);
    }

    public static ImmutableCreateStickerSet copyOf(CreateStickerSet instance) {
        if (instance instanceof ImmutableCreateStickerSet) {
            return (ImmutableCreateStickerSet)instance;
        }
        return ImmutableCreateStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_SHORT_NAME = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MASKS = 4L;
        private static final long OPT_BIT_ANIMATED = 8L;
        private static final long OPT_BIT_VIDEOS = 16L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean masks;
        private boolean animated;
        private boolean videos;
        private InputUser userId;
        private String title;
        private String shortName;
        private InputDocument thumb;
        private List<InputStickerSetItem> stickers = new ArrayList<InputStickerSetItem>();
        private String software;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CreateStickerSet) {
                InputDocument thumbValue;
                String softwareValue;
                instance = (CreateStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((softwareValue = instance.software()) != null) {
                    this.software(softwareValue);
                }
                if ((thumbValue = instance.thumb()) != null) {
                    this.thumb(thumbValue);
                }
                this.flags(instance.flags());
                this.animated(instance.animated());
                this.masks(instance.masks());
                this.videos(instance.videos());
                this.addAllStickers(instance.stickers());
                this.title(instance.title());
                this.shortName(instance.shortName());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder masks(boolean masks) {
            this.masks = masks;
            this.optBits |= 4L;
            return this;
        }

        public final Builder animated(boolean animated) {
            this.animated = animated;
            this.optBits |= 8L;
            return this;
        }

        public final Builder videos(boolean videos) {
            this.videos = videos;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder thumb(@Nullable InputDocument thumb) {
            this.thumb = thumb;
            return this;
        }

        public final Builder addSticker(InputStickerSetItem element) {
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(InputStickerSetItem ... elements) {
            for (InputStickerSetItem element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(Iterable<? extends InputStickerSetItem> elements) {
            this.stickers.clear();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends InputStickerSetItem> elements) {
            for (InputStickerSetItem inputStickerSetItem : elements) {
                this.stickers.add(Objects.requireNonNull(inputStickerSetItem, "stickers element"));
            }
            return this;
        }

        public final Builder software(@Nullable String software) {
            this.software = software;
            return this;
        }

        public ImmutableCreateStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean masksIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean animatedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean videosIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("shortName");
            }
            return "Cannot build CreateStickerSet, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte masksBuildStage = 0;
        private boolean masks;
        private byte animatedBuildStage = 0;
        private boolean animated;
        private byte videosBuildStage = 0;
        private boolean videos;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCreateStickerSet.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCreateStickerSet.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean masks() {
            if (this.masksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masksBuildStage == 0) {
                this.masksBuildStage = (byte)-1;
                this.masks = ImmutableCreateStickerSet.this.masksInitialize();
                this.masksBuildStage = 1;
            }
            return this.masks;
        }

        void masks(boolean masks) {
            this.masks = masks;
            this.masksBuildStage = 1;
        }

        boolean animated() {
            if (this.animatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.animatedBuildStage == 0) {
                this.animatedBuildStage = (byte)-1;
                this.animated = ImmutableCreateStickerSet.this.animatedInitialize();
                this.animatedBuildStage = 1;
            }
            return this.animated;
        }

        void animated(boolean animated) {
            this.animated = animated;
            this.animatedBuildStage = 1;
        }

        boolean videos() {
            if (this.videosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videosBuildStage == 0) {
                this.videosBuildStage = (byte)-1;
                this.videos = ImmutableCreateStickerSet.this.videosInitialize();
                this.videosBuildStage = 1;
            }
            return this.videos;
        }

        void videos(boolean videos) {
            this.videos = videos;
            this.videosBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.masksBuildStage == -1) {
                attributes.add("masks");
            }
            if (this.animatedBuildStage == -1) {
                attributes.add("animated");
            }
            if (this.videosBuildStage == -1) {
                attributes.add("videos");
            }
            return "Cannot build CreateStickerSet, attribute initializers form cycle " + attributes;
        }
    }
}

