/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stickers;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stickers.RemoveStickerFromSet;

public final class ImmutableRemoveStickerFromSet
implements RemoveStickerFromSet {
    private final int identifier;
    private final InputDocument sticker;

    private ImmutableRemoveStickerFromSet(InputDocument sticker) {
        this.sticker = Objects.requireNonNull(sticker, "sticker");
        this.identifier = RemoveStickerFromSet.super.identifier();
    }

    private ImmutableRemoveStickerFromSet(Builder builder) {
        this.sticker = builder.sticker;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RemoveStickerFromSet.super.identifier();
    }

    private ImmutableRemoveStickerFromSet(int identifier, InputDocument sticker) {
        this.identifier = identifier;
        this.sticker = sticker;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument sticker() {
        return this.sticker;
    }

    public final ImmutableRemoveStickerFromSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRemoveStickerFromSet(value, this.sticker);
    }

    public final ImmutableRemoveStickerFromSet withSticker(InputDocument value) {
        if (this.sticker == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "sticker");
        return new ImmutableRemoveStickerFromSet(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemoveStickerFromSet && this.equalTo(0, (ImmutableRemoveStickerFromSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableRemoveStickerFromSet another) {
        return this.identifier == another.identifier && this.sticker.equals(another.sticker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.sticker.hashCode();
        return h;
    }

    public String toString() {
        return "RemoveStickerFromSet{identifier=" + this.identifier + ", sticker=" + this.sticker + "}";
    }

    public static ImmutableRemoveStickerFromSet of(InputDocument sticker) {
        return new ImmutableRemoveStickerFromSet(sticker);
    }

    public static ImmutableRemoveStickerFromSet copyOf(RemoveStickerFromSet instance) {
        if (instance instanceof ImmutableRemoveStickerFromSet) {
            return (ImmutableRemoveStickerFromSet)instance;
        }
        return ImmutableRemoveStickerFromSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputDocument sticker;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RemoveStickerFromSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RemoveStickerFromSet) {
                instance = (RemoveStickerFromSet)object;
                this.sticker(instance.sticker());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sticker(InputDocument sticker) {
            this.sticker = Objects.requireNonNull(sticker, "sticker");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRemoveStickerFromSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRemoveStickerFromSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sticker");
            }
            return "Cannot build RemoveStickerFromSet, some of required attributes are not set " + attributes;
        }
    }
}

