/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.stickers;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.stickers.SetStickerSetThumb;

public final class ImmutableSetStickerSetThumb
implements SetStickerSetThumb {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final InputDocument thumb;

    private ImmutableSetStickerSetThumb(InputStickerSet stickerset, InputDocument thumb) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.thumb = Objects.requireNonNull(thumb, "thumb");
        this.identifier = SetStickerSetThumb.super.identifier();
    }

    private ImmutableSetStickerSetThumb(Builder builder) {
        this.stickerset = builder.stickerset;
        this.thumb = builder.thumb;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetStickerSetThumb.super.identifier();
    }

    private ImmutableSetStickerSetThumb(int identifier, InputStickerSet stickerset, InputDocument thumb) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.thumb = thumb;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public InputDocument thumb() {
        return this.thumb;
    }

    public final ImmutableSetStickerSetThumb withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetStickerSetThumb(value, this.stickerset, this.thumb);
    }

    public final ImmutableSetStickerSetThumb withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableSetStickerSetThumb(this.identifier, newValue, this.thumb);
    }

    public final ImmutableSetStickerSetThumb withThumb(InputDocument value) {
        if (this.thumb == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "thumb");
        return new ImmutableSetStickerSetThumb(this.identifier, this.stickerset, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetStickerSetThumb && this.equalTo(0, (ImmutableSetStickerSetThumb)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetStickerSetThumb another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.thumb.equals(another.thumb);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + this.thumb.hashCode();
        return h;
    }

    public String toString() {
        return "SetStickerSetThumb{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", thumb=" + this.thumb + "}";
    }

    public static ImmutableSetStickerSetThumb of(InputStickerSet stickerset, InputDocument thumb) {
        return new ImmutableSetStickerSetThumb(stickerset, thumb);
    }

    public static ImmutableSetStickerSetThumb copyOf(SetStickerSetThumb instance) {
        if (instance instanceof ImmutableSetStickerSetThumb) {
            return (ImmutableSetStickerSetThumb)instance;
        }
        return ImmutableSetStickerSetThumb.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_THUMB = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private InputDocument thumb;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetStickerSetThumb instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetStickerSetThumb) {
                instance = (SetStickerSetThumb)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.thumb(instance.thumb());
                this.stickerset(instance.stickerset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder thumb(InputDocument thumb) {
            this.thumb = Objects.requireNonNull(thumb, "thumb");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetStickerSetThumb build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetStickerSetThumb(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("thumb");
            }
            return "Cannot build SetStickerSetThumb, some of required attributes are not set " + attributes;
        }
    }
}

