/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.updates;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelMessagesFilter;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.updates.GetChannelDifference;

public final class ImmutableGetChannelDifference
implements GetChannelDifference {
    private final int identifier;
    private final int flags;
    private final boolean force;
    private final InputChannel channel;
    private final ChannelMessagesFilter filter;
    private final int pts;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetChannelDifference(InputChannel channel, ChannelMessagesFilter filter, int pts, int limit) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.pts = pts;
        this.limit = limit;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableGetChannelDifference(Builder builder) {
        this.channel = builder.channel;
        this.filter = builder.filter;
        this.pts = builder.pts;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.forceIsSet()) {
            this.initShim.force(builder.force);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableGetChannelDifference(int identifier, int flags, boolean force, InputChannel channel, ChannelMessagesFilter filter, int pts, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.force = force;
        this.channel = channel;
        this.filter = filter;
        this.pts = pts;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetChannelDifference.super.identifier();
    }

    private int flagsInitialize() {
        return GetChannelDifference.super.flags();
    }

    private boolean forceInitialize() {
        return GetChannelDifference.super.force();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean force() {
        InitShim shim = this.initShim;
        return shim != null ? shim.force() : this.force;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public ChannelMessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetChannelDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetChannelDifference(value, this.flags, this.force, this.channel, this.filter, this.pts, this.limit);
    }

    public final ImmutableGetChannelDifference withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetChannelDifference(this.identifier, value, this.force, this.channel, this.filter, this.pts, this.limit);
    }

    public final ImmutableGetChannelDifference withForce(boolean value) {
        if (this.force == value) {
            return this;
        }
        return new ImmutableGetChannelDifference(this.identifier, this.flags, value, this.channel, this.filter, this.pts, this.limit);
    }

    public final ImmutableGetChannelDifference withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetChannelDifference(this.identifier, this.flags, this.force, newValue, this.filter, this.pts, this.limit);
    }

    public final ImmutableGetChannelDifference withFilter(ChannelMessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        ChannelMessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableGetChannelDifference(this.identifier, this.flags, this.force, this.channel, newValue, this.pts, this.limit);
    }

    public final ImmutableGetChannelDifference withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableGetChannelDifference(this.identifier, this.flags, this.force, this.channel, this.filter, value, this.limit);
    }

    public final ImmutableGetChannelDifference withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetChannelDifference(this.identifier, this.flags, this.force, this.channel, this.filter, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetChannelDifference && this.equalTo(0, (ImmutableGetChannelDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetChannelDifference another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.force == another.force && this.channel.equals(another.channel) && this.filter.equals(another.filter) && this.pts == another.pts && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.force);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetChannelDifference{identifier=" + this.identifier + ", flags=" + this.flags + ", force=" + this.force + ", channel=" + this.channel + ", filter=" + this.filter + ", pts=" + this.pts + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetChannelDifference of(InputChannel channel, ChannelMessagesFilter filter, int pts, int limit) {
        return new ImmutableGetChannelDifference(channel, filter, pts, limit);
    }

    public static ImmutableGetChannelDifference copyOf(GetChannelDifference instance) {
        if (instance instanceof ImmutableGetChannelDifference) {
            return (ImmutableGetChannelDifference)instance;
        }
        return ImmutableGetChannelDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_PTS = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FORCE = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean force;
        private InputChannel channel;
        private ChannelMessagesFilter filter;
        private int pts;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetChannelDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetChannelDifference) {
                instance = (GetChannelDifference)object;
                this.filter(instance.filter());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.channel(instance.channel());
                this.limit(instance.limit());
                this.force(instance.force());
                this.pts(instance.pts());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder force(boolean force) {
            this.force = force;
            this.optBits |= 4L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(ChannelMessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetChannelDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetChannelDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean forceIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetChannelDifference, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte forceBuildStage = 0;
        private boolean force;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetChannelDifference.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetChannelDifference.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean force() {
            if (this.forceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceBuildStage == 0) {
                this.forceBuildStage = (byte)-1;
                this.force = ImmutableGetChannelDifference.this.forceInitialize();
                this.forceBuildStage = 1;
            }
            return this.force;
        }

        void force(boolean force) {
            this.force = force;
            this.forceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.forceBuildStage == -1) {
                attributes.add("force");
            }
            return "Cannot build GetChannelDifference, attribute initializers form cycle " + attributes;
        }
    }
}

