/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.updates;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.updates.GetDifference;

public final class ImmutableGetDifference
implements GetDifference {
    private final int identifier;
    private final int flags;
    private final int pts;
    @Nullable
    private final Integer ptsTotalLimit;
    private final int date;
    private final int qts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetDifference(int pts, int date, int qts) {
        this.pts = pts;
        this.date = date;
        this.qts = qts;
        this.ptsTotalLimit = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetDifference(Builder builder) {
        this.pts = builder.pts;
        this.ptsTotalLimit = builder.ptsTotalLimit;
        this.date = builder.date;
        this.qts = builder.qts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetDifference(int identifier, int flags, int pts, @Nullable Integer ptsTotalLimit, int date, int qts) {
        this.identifier = identifier;
        this.flags = flags;
        this.pts = pts;
        this.ptsTotalLimit = ptsTotalLimit;
        this.date = date;
        this.qts = qts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetDifference.super.identifier();
    }

    private int flagsInitialize() {
        return GetDifference.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    @Nullable
    public Integer ptsTotalLimit() {
        return this.ptsTotalLimit;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableGetDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDifference(value, this.flags, this.pts, this.ptsTotalLimit, this.date, this.qts);
    }

    public final ImmutableGetDifference withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, value, this.pts, this.ptsTotalLimit, this.date, this.qts);
    }

    public final ImmutableGetDifference withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.flags, value, this.ptsTotalLimit, this.date, this.qts);
    }

    public final ImmutableGetDifference withPtsTotalLimit(@Nullable Integer value) {
        if (Objects.equals(this.ptsTotalLimit, value)) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.flags, this.pts, value, this.date, this.qts);
    }

    public final ImmutableGetDifference withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.flags, this.pts, this.ptsTotalLimit, value, this.qts);
    }

    public final ImmutableGetDifference withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.flags, this.pts, this.ptsTotalLimit, this.date, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDifference && this.equalTo(0, (ImmutableGetDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDifference another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pts == another.pts && Objects.equals(this.ptsTotalLimit, another.ptsTotalLimit) && this.date == another.date && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.pts;
        h += (h << 5) + Objects.hashCode(this.ptsTotalLimit);
        h += (h << 5) + this.date;
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "GetDifference{identifier=" + this.identifier + ", flags=" + this.flags + ", pts=" + this.pts + ", ptsTotalLimit=" + this.ptsTotalLimit + ", date=" + this.date + ", qts=" + this.qts + "}";
    }

    public static ImmutableGetDifference of(int pts, int date, int qts) {
        return new ImmutableGetDifference(pts, date, qts);
    }

    public static ImmutableGetDifference copyOf(GetDifference instance) {
        if (instance instanceof ImmutableGetDifference) {
            return (ImmutableGetDifference)instance;
        }
        return ImmutableGetDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_QTS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private int pts;
        private Integer ptsTotalLimit;
        private int date;
        private int qts;

        private Builder() {
        }

        public final Builder from(GetDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetDifference instance;
            long bits = 0L;
            if (object instanceof GetDifference) {
                instance = (GetDifference)object;
                this.date(instance.date());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.qts(instance.qts());
                Integer ptsTotalLimitValue = instance.ptsTotalLimit();
                if (ptsTotalLimitValue != null) {
                    this.ptsTotalLimit(ptsTotalLimitValue);
                }
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsTotalLimit(@Nullable Integer ptsTotalLimit) {
            this.ptsTotalLimit = ptsTotalLimit;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build GetDifference, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetDifference.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetDifference.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetDifference, attribute initializers form cycle " + attributes;
        }
    }
}

