/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.updates;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.updates.GetState;

public final class ImmutableGetState
implements GetState {
    private final int identifier;
    private static final ImmutableGetState INSTANCE = ImmutableGetState.validate(new ImmutableGetState());

    private ImmutableGetState() {
        this.identifier = GetState.super.identifier();
    }

    private ImmutableGetState(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetState.super.identifier();
    }

    private ImmutableGetState(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableGetState withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetState.validate(new ImmutableGetState(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetState && this.equalTo(0, (ImmutableGetState)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetState another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "GetState{identifier=" + this.identifier + "}";
    }

    public static ImmutableGetState of() {
        return INSTANCE;
    }

    private static ImmutableGetState validate(ImmutableGetState instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetState copyOf(GetState instance) {
        if (instance instanceof ImmutableGetState) {
            return (ImmutableGetState)instance;
        }
        return ImmutableGetState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetState instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetState) {
                instance = (GetState)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGetState build() {
            return ImmutableGetState.validate(new ImmutableGetState(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

