/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.GetCdnFile;

public final class ImmutableGetCdnFile
implements GetCdnFile {
    private final int identifier;
    private final ByteBuf fileToken;
    private final long offset;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetCdnFile(long offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.fileToken = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetCdnFile(Builder builder) {
        this.fileToken = builder.fileToken_build();
        this.offset = builder.offset;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetCdnFile(int identifier, ByteBuf fileToken, long offset, int limit) {
        this.identifier = identifier;
        this.fileToken = fileToken;
        this.offset = offset;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetCdnFile.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf fileToken() {
        return this.fileToken.duplicate();
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetCdnFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetCdnFile(value, this.fileToken, this.offset, this.limit);
    }

    public ImmutableGetCdnFile withFileToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileToken == newValue) {
            return this;
        }
        return new ImmutableGetCdnFile(this.identifier, newValue, this.offset, this.limit);
    }

    public final ImmutableGetCdnFile withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetCdnFile(this.identifier, this.fileToken, value, this.limit);
    }

    public final ImmutableGetCdnFile withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetCdnFile(this.identifier, this.fileToken, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetCdnFile && this.equalTo(0, (ImmutableGetCdnFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetCdnFile another) {
        return this.identifier == another.identifier && this.fileToken().equals((Object)another.fileToken()) && this.offset == another.offset && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fileToken().hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetCdnFile{identifier=" + this.identifier + ", fileToken=" + ByteBufUtil.hexDump((ByteBuf)this.fileToken) + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetCdnFile of(long offset, int limit) {
        return new ImmutableGetCdnFile(offset, limit);
    }

    public static ImmutableGetCdnFile copyOf(GetCdnFile instance) {
        if (instance instanceof ImmutableGetCdnFile) {
            return (ImmutableGetCdnFile)instance;
        }
        return ImmutableGetCdnFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf fileToken_value = null;
        private int identifier;
        private long offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetCdnFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetCdnFile instance;
            long bits = 0L;
            if (object instanceof GetCdnFile) {
                instance = (GetCdnFile)object;
                this.fileToken(instance.fileToken());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder fileToken(ByteBuf value) {
            this.fileToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetCdnFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetCdnFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetCdnFile, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileToken_build() {
            return Objects.requireNonNull(this.fileToken_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetCdnFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build GetCdnFile, attribute initializers form cycle " + attributes;
        }
    }
}

