/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.GetCdnFileHashes;

public final class ImmutableGetCdnFileHashes
implements GetCdnFileHashes {
    private final int identifier;
    private final ByteBuf fileToken;
    private final long offset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetCdnFileHashes(long offset) {
        this.offset = offset;
        this.fileToken = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetCdnFileHashes(Builder builder) {
        this.fileToken = builder.fileToken_build();
        this.offset = builder.offset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetCdnFileHashes(int identifier, ByteBuf fileToken, long offset) {
        this.identifier = identifier;
        this.fileToken = fileToken;
        this.offset = offset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetCdnFileHashes.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf fileToken() {
        return this.fileToken.duplicate();
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public final ImmutableGetCdnFileHashes withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetCdnFileHashes(value, this.fileToken, this.offset);
    }

    public ImmutableGetCdnFileHashes withFileToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileToken == newValue) {
            return this;
        }
        return new ImmutableGetCdnFileHashes(this.identifier, newValue, this.offset);
    }

    public final ImmutableGetCdnFileHashes withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetCdnFileHashes(this.identifier, this.fileToken, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetCdnFileHashes && this.equalTo(0, (ImmutableGetCdnFileHashes)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetCdnFileHashes another) {
        return this.identifier == another.identifier && this.fileToken().equals((Object)another.fileToken()) && this.offset == another.offset;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fileToken().hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        return h;
    }

    public String toString() {
        return "GetCdnFileHashes{identifier=" + this.identifier + ", fileToken=" + ByteBufUtil.hexDump((ByteBuf)this.fileToken) + ", offset=" + this.offset + "}";
    }

    public static ImmutableGetCdnFileHashes of(long offset) {
        return new ImmutableGetCdnFileHashes(offset);
    }

    public static ImmutableGetCdnFileHashes copyOf(GetCdnFileHashes instance) {
        if (instance instanceof ImmutableGetCdnFileHashes) {
            return (ImmutableGetCdnFileHashes)instance;
        }
        return ImmutableGetCdnFileHashes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf fileToken_value = null;
        private int identifier;
        private long offset;

        private Builder() {
        }

        public final Builder from(GetCdnFileHashes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetCdnFileHashes instance;
            long bits = 0L;
            if (object instanceof GetCdnFileHashes) {
                instance = (GetCdnFileHashes)object;
                this.fileToken(instance.fileToken());
                this.offset(instance.offset());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder fileToken(ByteBuf value) {
            this.fileToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetCdnFileHashes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetCdnFileHashes(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build GetCdnFileHashes, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileToken_build() {
            return Objects.requireNonNull(this.fileToken_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetCdnFileHashes.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build GetCdnFileHashes, attribute initializers form cycle " + attributes;
        }
    }
}

