/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.GetFile;

public final class ImmutableGetFile
implements GetFile {
    private final int identifier;
    private final int flags;
    private final boolean precise;
    private final boolean cdnSupported;
    private final InputFileLocation location;
    private final long offset;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetFile(InputFileLocation location, long offset, int limit) {
        this.location = Objects.requireNonNull(location, "location");
        this.offset = offset;
        this.limit = limit;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.precise = this.initShim.precise();
        this.cdnSupported = this.initShim.cdnSupported();
        this.initShim = null;
    }

    private ImmutableGetFile(Builder builder) {
        this.location = builder.location;
        this.offset = builder.offset;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.preciseIsSet()) {
            this.initShim.precise(builder.precise);
        }
        if (builder.cdnSupportedIsSet()) {
            this.initShim.cdnSupported(builder.cdnSupported);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.precise = this.initShim.precise();
        this.cdnSupported = this.initShim.cdnSupported();
        this.initShim = null;
    }

    private ImmutableGetFile(int identifier, int flags, boolean precise, boolean cdnSupported, InputFileLocation location, long offset, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.precise = precise;
        this.cdnSupported = cdnSupported;
        this.location = location;
        this.offset = offset;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetFile.super.identifier();
    }

    private int flagsInitialize() {
        return GetFile.super.flags();
    }

    private boolean preciseInitialize() {
        return GetFile.super.precise();
    }

    private boolean cdnSupportedInitialize() {
        return GetFile.super.cdnSupported();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean precise() {
        InitShim shim = this.initShim;
        return shim != null ? shim.precise() : this.precise;
    }

    @Override
    public boolean cdnSupported() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cdnSupported() : this.cdnSupported;
    }

    @Override
    public InputFileLocation location() {
        return this.location;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetFile(value, this.flags, this.precise, this.cdnSupported, this.location, this.offset, this.limit);
    }

    public final ImmutableGetFile withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetFile(this.identifier, value, this.precise, this.cdnSupported, this.location, this.offset, this.limit);
    }

    public final ImmutableGetFile withPrecise(boolean value) {
        if (this.precise == value) {
            return this;
        }
        return new ImmutableGetFile(this.identifier, this.flags, value, this.cdnSupported, this.location, this.offset, this.limit);
    }

    public final ImmutableGetFile withCdnSupported(boolean value) {
        if (this.cdnSupported == value) {
            return this;
        }
        return new ImmutableGetFile(this.identifier, this.flags, this.precise, value, this.location, this.offset, this.limit);
    }

    public final ImmutableGetFile withLocation(InputFileLocation value) {
        if (this.location == value) {
            return this;
        }
        InputFileLocation newValue = Objects.requireNonNull(value, "location");
        return new ImmutableGetFile(this.identifier, this.flags, this.precise, this.cdnSupported, newValue, this.offset, this.limit);
    }

    public final ImmutableGetFile withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetFile(this.identifier, this.flags, this.precise, this.cdnSupported, this.location, value, this.limit);
    }

    public final ImmutableGetFile withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetFile(this.identifier, this.flags, this.precise, this.cdnSupported, this.location, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetFile && this.equalTo(0, (ImmutableGetFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetFile another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.precise == another.precise && this.cdnSupported == another.cdnSupported && this.location.equals(another.location) && this.offset == another.offset && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.precise);
        h += (h << 5) + Boolean.hashCode(this.cdnSupported);
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetFile{identifier=" + this.identifier + ", flags=" + this.flags + ", precise=" + this.precise + ", cdnSupported=" + this.cdnSupported + ", location=" + this.location + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetFile of(InputFileLocation location, long offset, int limit) {
        return new ImmutableGetFile(location, offset, limit);
    }

    public static ImmutableGetFile copyOf(GetFile instance) {
        if (instance instanceof ImmutableGetFile) {
            return (ImmutableGetFile)instance;
        }
        return ImmutableGetFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LOCATION = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PRECISE = 4L;
        private static final long OPT_BIT_CDN_SUPPORTED = 8L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean precise;
        private boolean cdnSupported;
        private InputFileLocation location;
        private long offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetFile) {
                instance = (GetFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.flags(instance.flags());
                this.limit(instance.limit());
                this.cdnSupported(instance.cdnSupported());
                this.location(instance.location());
                this.precise(instance.precise());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder precise(boolean precise) {
            this.precise = precise;
            this.optBits |= 4L;
            return this;
        }

        public final Builder cdnSupported(boolean cdnSupported) {
            this.cdnSupported = cdnSupported;
            this.optBits |= 8L;
            return this;
        }

        public final Builder location(InputFileLocation location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean preciseIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean cdnSupportedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("location");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetFile, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte preciseBuildStage = 0;
        private boolean precise;
        private byte cdnSupportedBuildStage = 0;
        private boolean cdnSupported;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetFile.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean precise() {
            if (this.preciseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.preciseBuildStage == 0) {
                this.preciseBuildStage = (byte)-1;
                this.precise = ImmutableGetFile.this.preciseInitialize();
                this.preciseBuildStage = 1;
            }
            return this.precise;
        }

        void precise(boolean precise) {
            this.precise = precise;
            this.preciseBuildStage = 1;
        }

        boolean cdnSupported() {
            if (this.cdnSupportedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cdnSupportedBuildStage == 0) {
                this.cdnSupportedBuildStage = (byte)-1;
                this.cdnSupported = ImmutableGetFile.this.cdnSupportedInitialize();
                this.cdnSupportedBuildStage = 1;
            }
            return this.cdnSupported;
        }

        void cdnSupported(boolean cdnSupported) {
            this.cdnSupported = cdnSupported;
            this.cdnSupportedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.preciseBuildStage == -1) {
                attributes.add("precise");
            }
            if (this.cdnSupportedBuildStage == -1) {
                attributes.add("cdnSupported");
            }
            return "Cannot build GetFile, attribute initializers form cycle " + attributes;
        }
    }
}

