/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.GetFileHashes;

public final class ImmutableGetFileHashes
implements GetFileHashes {
    private final int identifier;
    private final InputFileLocation location;
    private final long offset;

    private ImmutableGetFileHashes(InputFileLocation location, long offset) {
        this.location = Objects.requireNonNull(location, "location");
        this.offset = offset;
        this.identifier = GetFileHashes.super.identifier();
    }

    private ImmutableGetFileHashes(Builder builder) {
        this.location = builder.location;
        this.offset = builder.offset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetFileHashes.super.identifier();
    }

    private ImmutableGetFileHashes(int identifier, InputFileLocation location, long offset) {
        this.identifier = identifier;
        this.location = location;
        this.offset = offset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputFileLocation location() {
        return this.location;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public final ImmutableGetFileHashes withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetFileHashes(value, this.location, this.offset);
    }

    public final ImmutableGetFileHashes withLocation(InputFileLocation value) {
        if (this.location == value) {
            return this;
        }
        InputFileLocation newValue = Objects.requireNonNull(value, "location");
        return new ImmutableGetFileHashes(this.identifier, newValue, this.offset);
    }

    public final ImmutableGetFileHashes withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetFileHashes(this.identifier, this.location, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetFileHashes && this.equalTo(0, (ImmutableGetFileHashes)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetFileHashes another) {
        return this.identifier == another.identifier && this.location.equals(another.location) && this.offset == another.offset;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        return h;
    }

    public String toString() {
        return "GetFileHashes{identifier=" + this.identifier + ", location=" + this.location + ", offset=" + this.offset + "}";
    }

    public static ImmutableGetFileHashes of(InputFileLocation location, long offset) {
        return new ImmutableGetFileHashes(location, offset);
    }

    public static ImmutableGetFileHashes copyOf(GetFileHashes instance) {
        if (instance instanceof ImmutableGetFileHashes) {
            return (ImmutableGetFileHashes)instance;
        }
        return ImmutableGetFileHashes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LOCATION = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputFileLocation location;
        private long offset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetFileHashes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetFileHashes) {
                instance = (GetFileHashes)object;
                this.offset(instance.offset());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.location(instance.location());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder location(InputFileLocation location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetFileHashes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetFileHashes(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("location");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build GetFileHashes, some of required attributes are not set " + attributes;
        }
    }
}

