/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputWebFileLocation;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.GetWebFile;

public final class ImmutableGetWebFile
implements GetWebFile {
    private final int identifier;
    private final InputWebFileLocation location;
    private final int offset;
    private final int limit;

    private ImmutableGetWebFile(InputWebFileLocation location, int offset, int limit) {
        this.location = Objects.requireNonNull(location, "location");
        this.offset = offset;
        this.limit = limit;
        this.identifier = GetWebFile.super.identifier();
    }

    private ImmutableGetWebFile(Builder builder) {
        this.location = builder.location;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetWebFile.super.identifier();
    }

    private ImmutableGetWebFile(int identifier, InputWebFileLocation location, int offset, int limit) {
        this.identifier = identifier;
        this.location = location;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputWebFileLocation location() {
        return this.location;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetWebFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetWebFile(value, this.location, this.offset, this.limit);
    }

    public final ImmutableGetWebFile withLocation(InputWebFileLocation value) {
        if (this.location == value) {
            return this;
        }
        InputWebFileLocation newValue = Objects.requireNonNull(value, "location");
        return new ImmutableGetWebFile(this.identifier, newValue, this.offset, this.limit);
    }

    public final ImmutableGetWebFile withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetWebFile(this.identifier, this.location, value, this.limit);
    }

    public final ImmutableGetWebFile withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetWebFile(this.identifier, this.location, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetWebFile && this.equalTo(0, (ImmutableGetWebFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetWebFile another) {
        return this.identifier == another.identifier && this.location.equals(another.location) && this.offset == another.offset && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + this.offset;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetWebFile{identifier=" + this.identifier + ", location=" + this.location + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetWebFile of(InputWebFileLocation location, int offset, int limit) {
        return new ImmutableGetWebFile(location, offset, limit);
    }

    public static ImmutableGetWebFile copyOf(GetWebFile instance) {
        if (instance instanceof ImmutableGetWebFile) {
            return (ImmutableGetWebFile)instance;
        }
        return ImmutableGetWebFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LOCATION = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputWebFileLocation location;
        private int offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetWebFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetWebFile) {
                instance = (GetWebFile)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.location(instance.location());
                this.offset(instance.offset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder location(InputWebFileLocation location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetWebFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetWebFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("location");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetWebFile, some of required attributes are not set " + attributes;
        }
    }
}

