/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.ReuploadCdnFile;

public final class ImmutableReuploadCdnFile
implements ReuploadCdnFile {
    private final int identifier;
    private final ByteBuf fileToken;
    private final ByteBuf requestToken;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReuploadCdnFile(Builder builder) {
        this.fileToken = builder.fileToken_build();
        this.requestToken = builder.requestToken_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableReuploadCdnFile(int identifier, ByteBuf fileToken, ByteBuf requestToken) {
        this.identifier = identifier;
        this.fileToken = fileToken;
        this.requestToken = requestToken;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReuploadCdnFile.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf fileToken() {
        return this.fileToken.duplicate();
    }

    @Override
    public ByteBuf requestToken() {
        return this.requestToken.duplicate();
    }

    public final ImmutableReuploadCdnFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReuploadCdnFile(value, this.fileToken, this.requestToken);
    }

    public ImmutableReuploadCdnFile withFileToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileToken == newValue) {
            return this;
        }
        return new ImmutableReuploadCdnFile(this.identifier, newValue, this.requestToken);
    }

    public ImmutableReuploadCdnFile withRequestToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.requestToken == newValue) {
            return this;
        }
        return new ImmutableReuploadCdnFile(this.identifier, this.fileToken, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReuploadCdnFile && this.equalTo(0, (ImmutableReuploadCdnFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableReuploadCdnFile another) {
        return this.identifier == another.identifier && this.fileToken().equals((Object)another.fileToken()) && this.requestToken().equals((Object)another.requestToken());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fileToken().hashCode();
        h += (h << 5) + this.requestToken().hashCode();
        return h;
    }

    public String toString() {
        return "ReuploadCdnFile{identifier=" + this.identifier + ", fileToken=" + ByteBufUtil.hexDump((ByteBuf)this.fileToken) + ", requestToken=" + ByteBufUtil.hexDump((ByteBuf)this.requestToken) + "}";
    }

    public static ImmutableReuploadCdnFile copyOf(ReuploadCdnFile instance) {
        if (instance instanceof ImmutableReuploadCdnFile) {
            return (ImmutableReuploadCdnFile)instance;
        }
        return ImmutableReuploadCdnFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf fileToken_value = null;
        private ByteBuf requestToken_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReuploadCdnFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReuploadCdnFile) {
                instance = (ReuploadCdnFile)object;
                this.fileToken(instance.fileToken());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestToken(instance.requestToken());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder fileToken(ByteBuf value) {
            this.fileToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder requestToken(ByteBuf value) {
            this.requestToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableReuploadCdnFile build() {
            return new ImmutableReuploadCdnFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf fileToken_build() {
            return Objects.requireNonNull(this.fileToken_value);
        }

        private ByteBuf requestToken_build() {
            return Objects.requireNonNull(this.requestToken_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReuploadCdnFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ReuploadCdnFile, attribute initializers form cycle " + attributes;
        }
    }
}

