/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.upload.SaveBigFilePart;

public final class ImmutableSaveBigFilePart
implements SaveBigFilePart {
    private final int identifier;
    private final long fileId;
    private final int filePart;
    private final int fileTotalParts;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSaveBigFilePart(long fileId, int filePart, int fileTotalParts) {
        this.fileId = fileId;
        this.filePart = filePart;
        this.fileTotalParts = fileTotalParts;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSaveBigFilePart(Builder builder) {
        this.fileId = builder.fileId;
        this.filePart = builder.filePart;
        this.fileTotalParts = builder.fileTotalParts;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSaveBigFilePart(int identifier, long fileId, int filePart, int fileTotalParts, ByteBuf bytes) {
        this.identifier = identifier;
        this.fileId = fileId;
        this.filePart = filePart;
        this.fileTotalParts = fileTotalParts;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SaveBigFilePart.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long fileId() {
        return this.fileId;
    }

    @Override
    public int filePart() {
        return this.filePart;
    }

    @Override
    public int fileTotalParts() {
        return this.fileTotalParts;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutableSaveBigFilePart withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveBigFilePart(value, this.fileId, this.filePart, this.fileTotalParts, this.bytes);
    }

    public final ImmutableSaveBigFilePart withFileId(long value) {
        if (this.fileId == value) {
            return this;
        }
        return new ImmutableSaveBigFilePart(this.identifier, value, this.filePart, this.fileTotalParts, this.bytes);
    }

    public final ImmutableSaveBigFilePart withFilePart(int value) {
        if (this.filePart == value) {
            return this;
        }
        return new ImmutableSaveBigFilePart(this.identifier, this.fileId, value, this.fileTotalParts, this.bytes);
    }

    public final ImmutableSaveBigFilePart withFileTotalParts(int value) {
        if (this.fileTotalParts == value) {
            return this;
        }
        return new ImmutableSaveBigFilePart(this.identifier, this.fileId, this.filePart, value, this.bytes);
    }

    public ImmutableSaveBigFilePart withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutableSaveBigFilePart(this.identifier, this.fileId, this.filePart, this.fileTotalParts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveBigFilePart && this.equalTo(0, (ImmutableSaveBigFilePart)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveBigFilePart another) {
        return this.identifier == another.identifier && this.fileId == another.fileId && this.filePart == another.filePart && this.fileTotalParts == another.fileTotalParts && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.fileId);
        h += (h << 5) + this.filePart;
        h += (h << 5) + this.fileTotalParts;
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "SaveBigFilePart{identifier=" + this.identifier + ", fileId=" + this.fileId + ", filePart=" + this.filePart + ", fileTotalParts=" + this.fileTotalParts + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutableSaveBigFilePart of(long fileId, int filePart, int fileTotalParts) {
        return new ImmutableSaveBigFilePart(fileId, filePart, fileTotalParts);
    }

    public static ImmutableSaveBigFilePart copyOf(SaveBigFilePart instance) {
        if (instance instanceof ImmutableSaveBigFilePart) {
            return (ImmutableSaveBigFilePart)instance;
        }
        return ImmutableSaveBigFilePart.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE_ID = 1L;
        private static final long INIT_BIT_FILE_PART = 2L;
        private static final long INIT_BIT_FILE_TOTAL_PARTS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private long fileId;
        private int filePart;
        private int fileTotalParts;

        private Builder() {
        }

        public final Builder from(SaveBigFilePart instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveBigFilePart instance;
            long bits = 0L;
            if (object instanceof SaveBigFilePart) {
                instance = (SaveBigFilePart)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.filePart(instance.filePart());
                this.fileTotalParts(instance.fileTotalParts());
                this.bytes(instance.bytes());
                this.fileId(instance.fileId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder fileId(long fileId) {
            this.fileId = fileId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filePart(int filePart) {
            this.filePart = filePart;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fileTotalParts(int fileTotalParts) {
            this.fileTotalParts = fileTotalParts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSaveBigFilePart build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveBigFilePart(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filePart");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fileTotalParts");
            }
            return "Cannot build SaveBigFilePart, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSaveBigFilePart.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SaveBigFilePart, attribute initializers form cycle " + attributes;
        }
    }
}

