/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.users;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.users.GetFullUser;

public final class ImmutableGetFullUser
implements GetFullUser {
    private final int identifier;
    private final InputUser id;

    private ImmutableGetFullUser(InputUser id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = GetFullUser.super.identifier();
    }

    private ImmutableGetFullUser(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetFullUser.super.identifier();
    }

    private ImmutableGetFullUser(int identifier, InputUser id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser id() {
        return this.id;
    }

    public final ImmutableGetFullUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetFullUser(value, this.id);
    }

    public final ImmutableGetFullUser withId(InputUser value) {
        if (this.id == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "id");
        return new ImmutableGetFullUser(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetFullUser && this.equalTo(0, (ImmutableGetFullUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetFullUser another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "GetFullUser{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableGetFullUser of(InputUser id) {
        return new ImmutableGetFullUser(id);
    }

    public static ImmutableGetFullUser copyOf(GetFullUser instance) {
        if (instance instanceof ImmutableGetFullUser) {
            return (ImmutableGetFullUser)instance;
        }
        return ImmutableGetFullUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputUser id;

        private Builder() {
        }

        public final Builder from(GetFullUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetFullUser instance;
            long bits = 0L;
            if (object instanceof GetFullUser) {
                instance = (GetFullUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputUser id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetFullUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetFullUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build GetFullUser, some of required attributes are not set " + attributes;
        }
    }
}

