/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.users;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.users.GetUsers;

public final class ImmutableGetUsers
implements GetUsers {
    private final int identifier;
    private final List<InputUser> id;

    private ImmutableGetUsers(Builder builder) {
        this.id = ImmutableGetUsers.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetUsers.super.identifier();
    }

    private ImmutableGetUsers(int identifier, List<InputUser> id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputUser> id() {
        return this.id;
    }

    public final ImmutableGetUsers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetUsers(value, this.id);
    }

    public final ImmutableGetUsers withId(InputUser ... elements) {
        List<InputUser> newValue = ImmutableGetUsers.createUnmodifiableList(false, ImmutableGetUsers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetUsers(this.identifier, newValue);
    }

    public final ImmutableGetUsers withId(Iterable<? extends InputUser> elements) {
        if (this.id == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableGetUsers.createUnmodifiableList(false, ImmutableGetUsers.createSafeList(elements, true, false));
        return new ImmutableGetUsers(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetUsers && this.equalTo(0, (ImmutableGetUsers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetUsers another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "GetUsers{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableGetUsers copyOf(GetUsers instance) {
        if (instance instanceof ImmutableGetUsers) {
            return (ImmutableGetUsers)instance;
        }
        return ImmutableGetUsers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputUser> id = new ArrayList<InputUser>();

        private Builder() {
        }

        public final Builder from(GetUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetUsers instance;
            long bits = 0L;
            if (object instanceof GetUsers) {
                instance = (GetUsers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addId(InputUser element) {
            this.id.add(Objects.requireNonNull(element, "id element"));
            return this;
        }

        public final Builder addId(InputUser ... elements) {
            for (InputUser element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder id(Iterable<? extends InputUser> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.id.add(Objects.requireNonNull(inputUser, "id element"));
            }
            return this;
        }

        public ImmutableGetUsers build() {
            return new ImmutableGetUsers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

