/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.users;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.SecureValueError;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.users.SetSecureValueErrors;

public final class ImmutableSetSecureValueErrors
implements SetSecureValueErrors {
    private final int identifier;
    private final InputUser id;
    private final List<SecureValueError> errors;

    private ImmutableSetSecureValueErrors(InputUser id) {
        this.id = Objects.requireNonNull(id, "id");
        this.errors = Collections.emptyList();
        this.identifier = SetSecureValueErrors.super.identifier();
    }

    private ImmutableSetSecureValueErrors(Builder builder) {
        this.id = builder.id;
        this.errors = ImmutableSetSecureValueErrors.createUnmodifiableList(true, builder.errors);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetSecureValueErrors.super.identifier();
    }

    private ImmutableSetSecureValueErrors(int identifier, InputUser id, List<SecureValueError> errors) {
        this.identifier = identifier;
        this.id = id;
        this.errors = errors;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser id() {
        return this.id;
    }

    @Override
    public List<SecureValueError> errors() {
        return this.errors;
    }

    public final ImmutableSetSecureValueErrors withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetSecureValueErrors(value, this.id, this.errors);
    }

    public final ImmutableSetSecureValueErrors withId(InputUser value) {
        if (this.id == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "id");
        return new ImmutableSetSecureValueErrors(this.identifier, newValue, this.errors);
    }

    public final ImmutableSetSecureValueErrors withErrors(SecureValueError ... elements) {
        List<SecureValueError> newValue = ImmutableSetSecureValueErrors.createUnmodifiableList(false, ImmutableSetSecureValueErrors.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetSecureValueErrors(this.identifier, this.id, newValue);
    }

    public final ImmutableSetSecureValueErrors withErrors(Iterable<? extends SecureValueError> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<SecureValueError> newValue = ImmutableSetSecureValueErrors.createUnmodifiableList(false, ImmutableSetSecureValueErrors.createSafeList(elements, true, false));
        return new ImmutableSetSecureValueErrors(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetSecureValueErrors && this.equalTo(0, (ImmutableSetSecureValueErrors)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetSecureValueErrors another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return "SetSecureValueErrors{identifier=" + this.identifier + ", id=" + this.id + ", errors=" + this.errors + "}";
    }

    public static ImmutableSetSecureValueErrors of(InputUser id) {
        return new ImmutableSetSecureValueErrors(id);
    }

    public static ImmutableSetSecureValueErrors copyOf(SetSecureValueErrors instance) {
        if (instance instanceof ImmutableSetSecureValueErrors) {
            return (ImmutableSetSecureValueErrors)instance;
        }
        return ImmutableSetSecureValueErrors.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputUser id;
        private List<SecureValueError> errors = new ArrayList<SecureValueError>();

        private Builder() {
        }

        public final Builder from(SetSecureValueErrors instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetSecureValueErrors instance;
            long bits = 0L;
            if (object instanceof SetSecureValueErrors) {
                instance = (SetSecureValueErrors)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllErrors(instance.errors());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputUser id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addError(SecureValueError element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder addErrors(SecureValueError ... elements) {
            for (SecureValueError element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        public final Builder errors(Iterable<? extends SecureValueError> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends SecureValueError> elements) {
            for (SecureValueError secureValueError : elements) {
                this.errors.add(Objects.requireNonNull(secureValueError, "errors element"));
            }
            return this;
        }

        public ImmutableSetSecureValueErrors build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetSecureValueErrors(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build SetSecureValueErrors, some of required attributes are not set " + attributes;
        }
    }
}

