/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.MessageInteractionCounters;
import telegram4j.tl.StatsAbsValueAndPrev;
import telegram4j.tl.StatsDateRangeDays;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.StatsPercentValue;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.stats.BroadcastStats;

public final class ImmutableBroadcastStats
implements BroadcastStats {
    private final int identifier;
    private final StatsDateRangeDays period;
    private final StatsAbsValueAndPrev followers;
    private final StatsAbsValueAndPrev viewsPerPost;
    private final StatsAbsValueAndPrev sharesPerPost;
    private final StatsPercentValue enabledNotifications;
    private final StatsGraph growthGraph;
    private final StatsGraph followersGraph;
    private final StatsGraph muteGraph;
    private final StatsGraph topHoursGraph;
    private final StatsGraph interactionsGraph;
    private final StatsGraph ivInteractionsGraph;
    private final StatsGraph viewsBySourceGraph;
    private final StatsGraph newFollowersBySourceGraph;
    private final StatsGraph languagesGraph;
    private final List<MessageInteractionCounters> recentMessageInteractions;

    private ImmutableBroadcastStats(StatsDateRangeDays period, StatsAbsValueAndPrev followers, StatsAbsValueAndPrev viewsPerPost, StatsAbsValueAndPrev sharesPerPost, StatsPercentValue enabledNotifications, StatsGraph growthGraph, StatsGraph followersGraph, StatsGraph muteGraph, StatsGraph topHoursGraph, StatsGraph interactionsGraph, StatsGraph ivInteractionsGraph, StatsGraph viewsBySourceGraph, StatsGraph newFollowersBySourceGraph, StatsGraph languagesGraph) {
        this.period = Objects.requireNonNull(period, "period");
        this.followers = Objects.requireNonNull(followers, "followers");
        this.viewsPerPost = Objects.requireNonNull(viewsPerPost, "viewsPerPost");
        this.sharesPerPost = Objects.requireNonNull(sharesPerPost, "sharesPerPost");
        this.enabledNotifications = Objects.requireNonNull(enabledNotifications, "enabledNotifications");
        this.growthGraph = Objects.requireNonNull(growthGraph, "growthGraph");
        this.followersGraph = Objects.requireNonNull(followersGraph, "followersGraph");
        this.muteGraph = Objects.requireNonNull(muteGraph, "muteGraph");
        this.topHoursGraph = Objects.requireNonNull(topHoursGraph, "topHoursGraph");
        this.interactionsGraph = Objects.requireNonNull(interactionsGraph, "interactionsGraph");
        this.ivInteractionsGraph = Objects.requireNonNull(ivInteractionsGraph, "ivInteractionsGraph");
        this.viewsBySourceGraph = Objects.requireNonNull(viewsBySourceGraph, "viewsBySourceGraph");
        this.newFollowersBySourceGraph = Objects.requireNonNull(newFollowersBySourceGraph, "newFollowersBySourceGraph");
        this.languagesGraph = Objects.requireNonNull(languagesGraph, "languagesGraph");
        this.recentMessageInteractions = Collections.emptyList();
        this.identifier = BroadcastStats.super.identifier();
    }

    private ImmutableBroadcastStats(Builder builder) {
        this.period = builder.period;
        this.followers = builder.followers;
        this.viewsPerPost = builder.viewsPerPost;
        this.sharesPerPost = builder.sharesPerPost;
        this.enabledNotifications = builder.enabledNotifications;
        this.growthGraph = builder.growthGraph;
        this.followersGraph = builder.followersGraph;
        this.muteGraph = builder.muteGraph;
        this.topHoursGraph = builder.topHoursGraph;
        this.interactionsGraph = builder.interactionsGraph;
        this.ivInteractionsGraph = builder.ivInteractionsGraph;
        this.viewsBySourceGraph = builder.viewsBySourceGraph;
        this.newFollowersBySourceGraph = builder.newFollowersBySourceGraph;
        this.languagesGraph = builder.languagesGraph;
        this.recentMessageInteractions = ImmutableBroadcastStats.createUnmodifiableList(true, builder.recentMessageInteractions);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BroadcastStats.super.identifier();
    }

    private ImmutableBroadcastStats(int identifier, StatsDateRangeDays period, StatsAbsValueAndPrev followers, StatsAbsValueAndPrev viewsPerPost, StatsAbsValueAndPrev sharesPerPost, StatsPercentValue enabledNotifications, StatsGraph growthGraph, StatsGraph followersGraph, StatsGraph muteGraph, StatsGraph topHoursGraph, StatsGraph interactionsGraph, StatsGraph ivInteractionsGraph, StatsGraph viewsBySourceGraph, StatsGraph newFollowersBySourceGraph, StatsGraph languagesGraph, List<MessageInteractionCounters> recentMessageInteractions) {
        this.identifier = identifier;
        this.period = period;
        this.followers = followers;
        this.viewsPerPost = viewsPerPost;
        this.sharesPerPost = sharesPerPost;
        this.enabledNotifications = enabledNotifications;
        this.growthGraph = growthGraph;
        this.followersGraph = followersGraph;
        this.muteGraph = muteGraph;
        this.topHoursGraph = topHoursGraph;
        this.interactionsGraph = interactionsGraph;
        this.ivInteractionsGraph = ivInteractionsGraph;
        this.viewsBySourceGraph = viewsBySourceGraph;
        this.newFollowersBySourceGraph = newFollowersBySourceGraph;
        this.languagesGraph = languagesGraph;
        this.recentMessageInteractions = recentMessageInteractions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StatsDateRangeDays period() {
        return this.period;
    }

    @Override
    public StatsAbsValueAndPrev followers() {
        return this.followers;
    }

    @Override
    public StatsAbsValueAndPrev viewsPerPost() {
        return this.viewsPerPost;
    }

    @Override
    public StatsAbsValueAndPrev sharesPerPost() {
        return this.sharesPerPost;
    }

    @Override
    public StatsPercentValue enabledNotifications() {
        return this.enabledNotifications;
    }

    @Override
    public StatsGraph growthGraph() {
        return this.growthGraph;
    }

    @Override
    public StatsGraph followersGraph() {
        return this.followersGraph;
    }

    @Override
    public StatsGraph muteGraph() {
        return this.muteGraph;
    }

    @Override
    public StatsGraph topHoursGraph() {
        return this.topHoursGraph;
    }

    @Override
    public StatsGraph interactionsGraph() {
        return this.interactionsGraph;
    }

    @Override
    public StatsGraph ivInteractionsGraph() {
        return this.ivInteractionsGraph;
    }

    @Override
    public StatsGraph viewsBySourceGraph() {
        return this.viewsBySourceGraph;
    }

    @Override
    public StatsGraph newFollowersBySourceGraph() {
        return this.newFollowersBySourceGraph;
    }

    @Override
    public StatsGraph languagesGraph() {
        return this.languagesGraph;
    }

    @Override
    public List<MessageInteractionCounters> recentMessageInteractions() {
        return this.recentMessageInteractions;
    }

    public final ImmutableBroadcastStats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBroadcastStats(value, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withPeriod(StatsDateRangeDays value) {
        if (this.period == value) {
            return this;
        }
        StatsDateRangeDays newValue = Objects.requireNonNull(value, "period");
        return new ImmutableBroadcastStats(this.identifier, newValue, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withFollowers(StatsAbsValueAndPrev value) {
        if (this.followers == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "followers");
        return new ImmutableBroadcastStats(this.identifier, this.period, newValue, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withViewsPerPost(StatsAbsValueAndPrev value) {
        if (this.viewsPerPost == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "viewsPerPost");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, newValue, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withSharesPerPost(StatsAbsValueAndPrev value) {
        if (this.sharesPerPost == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "sharesPerPost");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, newValue, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withEnabledNotifications(StatsPercentValue value) {
        if (this.enabledNotifications == value) {
            return this;
        }
        StatsPercentValue newValue = Objects.requireNonNull(value, "enabledNotifications");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, newValue, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withGrowthGraph(StatsGraph value) {
        if (this.growthGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "growthGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, newValue, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withFollowersGraph(StatsGraph value) {
        if (this.followersGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "followersGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, newValue, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withMuteGraph(StatsGraph value) {
        if (this.muteGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "muteGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, newValue, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withTopHoursGraph(StatsGraph value) {
        if (this.topHoursGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "topHoursGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, newValue, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withInteractionsGraph(StatsGraph value) {
        if (this.interactionsGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "interactionsGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, newValue, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withIvInteractionsGraph(StatsGraph value) {
        if (this.ivInteractionsGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "ivInteractionsGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, newValue, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withViewsBySourceGraph(StatsGraph value) {
        if (this.viewsBySourceGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "viewsBySourceGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, newValue, this.newFollowersBySourceGraph, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withNewFollowersBySourceGraph(StatsGraph value) {
        if (this.newFollowersBySourceGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "newFollowersBySourceGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, newValue, this.languagesGraph, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withLanguagesGraph(StatsGraph value) {
        if (this.languagesGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "languagesGraph");
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, newValue, this.recentMessageInteractions);
    }

    public final ImmutableBroadcastStats withRecentMessageInteractions(MessageInteractionCounters ... elements) {
        List<MessageInteractionCounters> newValue = ImmutableBroadcastStats.createUnmodifiableList(false, ImmutableBroadcastStats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, newValue);
    }

    public final ImmutableBroadcastStats withRecentMessageInteractions(Iterable<? extends MessageInteractionCounters> elements) {
        if (this.recentMessageInteractions == elements) {
            return this;
        }
        List<MessageInteractionCounters> newValue = ImmutableBroadcastStats.createUnmodifiableList(false, ImmutableBroadcastStats.createSafeList(elements, true, false));
        return new ImmutableBroadcastStats(this.identifier, this.period, this.followers, this.viewsPerPost, this.sharesPerPost, this.enabledNotifications, this.growthGraph, this.followersGraph, this.muteGraph, this.topHoursGraph, this.interactionsGraph, this.ivInteractionsGraph, this.viewsBySourceGraph, this.newFollowersBySourceGraph, this.languagesGraph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBroadcastStats && this.equalTo(0, (ImmutableBroadcastStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableBroadcastStats another) {
        return this.identifier == another.identifier && this.period.equals(another.period) && this.followers.equals(another.followers) && this.viewsPerPost.equals(another.viewsPerPost) && this.sharesPerPost.equals(another.sharesPerPost) && this.enabledNotifications.equals(another.enabledNotifications) && this.growthGraph.equals(another.growthGraph) && this.followersGraph.equals(another.followersGraph) && this.muteGraph.equals(another.muteGraph) && this.topHoursGraph.equals(another.topHoursGraph) && this.interactionsGraph.equals(another.interactionsGraph) && this.ivInteractionsGraph.equals(another.ivInteractionsGraph) && this.viewsBySourceGraph.equals(another.viewsBySourceGraph) && this.newFollowersBySourceGraph.equals(another.newFollowersBySourceGraph) && this.languagesGraph.equals(another.languagesGraph) && this.recentMessageInteractions.equals(another.recentMessageInteractions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.period.hashCode();
        h += (h << 5) + this.followers.hashCode();
        h += (h << 5) + this.viewsPerPost.hashCode();
        h += (h << 5) + this.sharesPerPost.hashCode();
        h += (h << 5) + this.enabledNotifications.hashCode();
        h += (h << 5) + this.growthGraph.hashCode();
        h += (h << 5) + this.followersGraph.hashCode();
        h += (h << 5) + this.muteGraph.hashCode();
        h += (h << 5) + this.topHoursGraph.hashCode();
        h += (h << 5) + this.interactionsGraph.hashCode();
        h += (h << 5) + this.ivInteractionsGraph.hashCode();
        h += (h << 5) + this.viewsBySourceGraph.hashCode();
        h += (h << 5) + this.newFollowersBySourceGraph.hashCode();
        h += (h << 5) + this.languagesGraph.hashCode();
        h += (h << 5) + this.recentMessageInteractions.hashCode();
        return h;
    }

    public String toString() {
        return "BroadcastStats{identifier=" + this.identifier + ", period=" + this.period + ", followers=" + this.followers + ", viewsPerPost=" + this.viewsPerPost + ", sharesPerPost=" + this.sharesPerPost + ", enabledNotifications=" + this.enabledNotifications + ", growthGraph=" + this.growthGraph + ", followersGraph=" + this.followersGraph + ", muteGraph=" + this.muteGraph + ", topHoursGraph=" + this.topHoursGraph + ", interactionsGraph=" + this.interactionsGraph + ", ivInteractionsGraph=" + this.ivInteractionsGraph + ", viewsBySourceGraph=" + this.viewsBySourceGraph + ", newFollowersBySourceGraph=" + this.newFollowersBySourceGraph + ", languagesGraph=" + this.languagesGraph + ", recentMessageInteractions=" + this.recentMessageInteractions + "}";
    }

    public static ImmutableBroadcastStats of(StatsDateRangeDays period, StatsAbsValueAndPrev followers, StatsAbsValueAndPrev viewsPerPost, StatsAbsValueAndPrev sharesPerPost, StatsPercentValue enabledNotifications, StatsGraph growthGraph, StatsGraph followersGraph, StatsGraph muteGraph, StatsGraph topHoursGraph, StatsGraph interactionsGraph, StatsGraph ivInteractionsGraph, StatsGraph viewsBySourceGraph, StatsGraph newFollowersBySourceGraph, StatsGraph languagesGraph) {
        return new ImmutableBroadcastStats(period, followers, viewsPerPost, sharesPerPost, enabledNotifications, growthGraph, followersGraph, muteGraph, topHoursGraph, interactionsGraph, ivInteractionsGraph, viewsBySourceGraph, newFollowersBySourceGraph, languagesGraph);
    }

    public static ImmutableBroadcastStats copyOf(BroadcastStats instance) {
        if (instance instanceof ImmutableBroadcastStats) {
            return (ImmutableBroadcastStats)instance;
        }
        return ImmutableBroadcastStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PERIOD = 1L;
        private static final long INIT_BIT_FOLLOWERS = 2L;
        private static final long INIT_BIT_VIEWS_PER_POST = 4L;
        private static final long INIT_BIT_SHARES_PER_POST = 8L;
        private static final long INIT_BIT_ENABLED_NOTIFICATIONS = 16L;
        private static final long INIT_BIT_GROWTH_GRAPH = 32L;
        private static final long INIT_BIT_FOLLOWERS_GRAPH = 64L;
        private static final long INIT_BIT_MUTE_GRAPH = 128L;
        private static final long INIT_BIT_TOP_HOURS_GRAPH = 256L;
        private static final long INIT_BIT_INTERACTIONS_GRAPH = 512L;
        private static final long INIT_BIT_IV_INTERACTIONS_GRAPH = 1024L;
        private static final long INIT_BIT_VIEWS_BY_SOURCE_GRAPH = 2048L;
        private static final long INIT_BIT_NEW_FOLLOWERS_BY_SOURCE_GRAPH = 4096L;
        private static final long INIT_BIT_LANGUAGES_GRAPH = 8192L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 16383L;
        private long optBits;
        private int identifier;
        private StatsDateRangeDays period;
        private StatsAbsValueAndPrev followers;
        private StatsAbsValueAndPrev viewsPerPost;
        private StatsAbsValueAndPrev sharesPerPost;
        private StatsPercentValue enabledNotifications;
        private StatsGraph growthGraph;
        private StatsGraph followersGraph;
        private StatsGraph muteGraph;
        private StatsGraph topHoursGraph;
        private StatsGraph interactionsGraph;
        private StatsGraph ivInteractionsGraph;
        private StatsGraph viewsBySourceGraph;
        private StatsGraph newFollowersBySourceGraph;
        private StatsGraph languagesGraph;
        private List<MessageInteractionCounters> recentMessageInteractions = new ArrayList<MessageInteractionCounters>();

        private Builder() {
        }

        public final Builder from(BroadcastStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BroadcastStats instance;
            long bits = 0L;
            if (object instanceof BroadcastStats) {
                instance = (BroadcastStats)object;
                this.addAllRecentMessageInteractions(instance.recentMessageInteractions());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
                this.followersGraph(instance.followersGraph());
                this.muteGraph(instance.muteGraph());
                this.languagesGraph(instance.languagesGraph());
                this.topHoursGraph(instance.topHoursGraph());
                this.ivInteractionsGraph(instance.ivInteractionsGraph());
                this.sharesPerPost(instance.sharesPerPost());
                this.interactionsGraph(instance.interactionsGraph());
                this.viewsBySourceGraph(instance.viewsBySourceGraph());
                this.followers(instance.followers());
                this.viewsPerPost(instance.viewsPerPost());
                this.enabledNotifications(instance.enabledNotifications());
                this.newFollowersBySourceGraph(instance.newFollowersBySourceGraph());
                this.growthGraph(instance.growthGraph());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder period(StatsDateRangeDays period) {
            this.period = Objects.requireNonNull(period, "period");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder followers(StatsAbsValueAndPrev followers) {
            this.followers = Objects.requireNonNull(followers, "followers");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder viewsPerPost(StatsAbsValueAndPrev viewsPerPost) {
            this.viewsPerPost = Objects.requireNonNull(viewsPerPost, "viewsPerPost");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sharesPerPost(StatsAbsValueAndPrev sharesPerPost) {
            this.sharesPerPost = Objects.requireNonNull(sharesPerPost, "sharesPerPost");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder enabledNotifications(StatsPercentValue enabledNotifications) {
            this.enabledNotifications = Objects.requireNonNull(enabledNotifications, "enabledNotifications");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder growthGraph(StatsGraph growthGraph) {
            this.growthGraph = Objects.requireNonNull(growthGraph, "growthGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder followersGraph(StatsGraph followersGraph) {
            this.followersGraph = Objects.requireNonNull(followersGraph, "followersGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder muteGraph(StatsGraph muteGraph) {
            this.muteGraph = Objects.requireNonNull(muteGraph, "muteGraph");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder topHoursGraph(StatsGraph topHoursGraph) {
            this.topHoursGraph = Objects.requireNonNull(topHoursGraph, "topHoursGraph");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder interactionsGraph(StatsGraph interactionsGraph) {
            this.interactionsGraph = Objects.requireNonNull(interactionsGraph, "interactionsGraph");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder ivInteractionsGraph(StatsGraph ivInteractionsGraph) {
            this.ivInteractionsGraph = Objects.requireNonNull(ivInteractionsGraph, "ivInteractionsGraph");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder viewsBySourceGraph(StatsGraph viewsBySourceGraph) {
            this.viewsBySourceGraph = Objects.requireNonNull(viewsBySourceGraph, "viewsBySourceGraph");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder newFollowersBySourceGraph(StatsGraph newFollowersBySourceGraph) {
            this.newFollowersBySourceGraph = Objects.requireNonNull(newFollowersBySourceGraph, "newFollowersBySourceGraph");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder languagesGraph(StatsGraph languagesGraph) {
            this.languagesGraph = Objects.requireNonNull(languagesGraph, "languagesGraph");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder addRecentMessageInteraction(MessageInteractionCounters element) {
            this.recentMessageInteractions.add(Objects.requireNonNull(element, "recentMessageInteractions element"));
            return this;
        }

        public final Builder addRecentMessageInteractions(MessageInteractionCounters ... elements) {
            for (MessageInteractionCounters element : elements) {
                this.recentMessageInteractions.add(Objects.requireNonNull(element, "recentMessageInteractions element"));
            }
            return this;
        }

        public final Builder recentMessageInteractions(Iterable<? extends MessageInteractionCounters> elements) {
            this.recentMessageInteractions.clear();
            return this.addAllRecentMessageInteractions(elements);
        }

        public final Builder addAllRecentMessageInteractions(Iterable<? extends MessageInteractionCounters> elements) {
            for (MessageInteractionCounters messageInteractionCounters : elements) {
                this.recentMessageInteractions.add(Objects.requireNonNull(messageInteractionCounters, "recentMessageInteractions element"));
            }
            return this;
        }

        public ImmutableBroadcastStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBroadcastStats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("period");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("followers");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("viewsPerPost");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sharesPerPost");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("enabledNotifications");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("growthGraph");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("followersGraph");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("muteGraph");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("topHoursGraph");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("interactionsGraph");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("ivInteractionsGraph");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("viewsBySourceGraph");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("newFollowersBySourceGraph");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("languagesGraph");
            }
            return "Cannot build BroadcastStats, some of required attributes are not set " + attributes;
        }
    }
}

