/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StatsAbsValueAndPrev;
import telegram4j.tl.StatsDateRangeDays;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.StatsGroupTopAdmin;
import telegram4j.tl.StatsGroupTopInviter;
import telegram4j.tl.StatsGroupTopPoster;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.stats.MegagroupStats;

public final class ImmutableMegagroupStats
implements MegagroupStats {
    private final int identifier;
    private final StatsDateRangeDays period;
    private final StatsAbsValueAndPrev members;
    private final StatsAbsValueAndPrev messages;
    private final StatsAbsValueAndPrev viewers;
    private final StatsAbsValueAndPrev posters;
    private final StatsGraph growthGraph;
    private final StatsGraph membersGraph;
    private final StatsGraph newMembersBySourceGraph;
    private final StatsGraph languagesGraph;
    private final StatsGraph messagesGraph;
    private final StatsGraph actionsGraph;
    private final StatsGraph topHoursGraph;
    private final StatsGraph weekdaysGraph;
    private final List<StatsGroupTopPoster> topPosters;
    private final List<StatsGroupTopAdmin> topAdmins;
    private final List<StatsGroupTopInviter> topInviters;
    private final List<User> users;

    private ImmutableMegagroupStats(StatsDateRangeDays period, StatsAbsValueAndPrev members, StatsAbsValueAndPrev messages, StatsAbsValueAndPrev viewers, StatsAbsValueAndPrev posters, StatsGraph growthGraph, StatsGraph membersGraph, StatsGraph newMembersBySourceGraph, StatsGraph languagesGraph, StatsGraph messagesGraph, StatsGraph actionsGraph, StatsGraph topHoursGraph, StatsGraph weekdaysGraph) {
        this.period = Objects.requireNonNull(period, "period");
        this.members = Objects.requireNonNull(members, "members");
        this.messages = Objects.requireNonNull(messages, "messages");
        this.viewers = Objects.requireNonNull(viewers, "viewers");
        this.posters = Objects.requireNonNull(posters, "posters");
        this.growthGraph = Objects.requireNonNull(growthGraph, "growthGraph");
        this.membersGraph = Objects.requireNonNull(membersGraph, "membersGraph");
        this.newMembersBySourceGraph = Objects.requireNonNull(newMembersBySourceGraph, "newMembersBySourceGraph");
        this.languagesGraph = Objects.requireNonNull(languagesGraph, "languagesGraph");
        this.messagesGraph = Objects.requireNonNull(messagesGraph, "messagesGraph");
        this.actionsGraph = Objects.requireNonNull(actionsGraph, "actionsGraph");
        this.topHoursGraph = Objects.requireNonNull(topHoursGraph, "topHoursGraph");
        this.weekdaysGraph = Objects.requireNonNull(weekdaysGraph, "weekdaysGraph");
        this.topPosters = Collections.emptyList();
        this.topAdmins = Collections.emptyList();
        this.topInviters = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = MegagroupStats.super.identifier();
    }

    private ImmutableMegagroupStats(Builder builder) {
        this.period = builder.period;
        this.members = builder.members;
        this.messages = builder.messages;
        this.viewers = builder.viewers;
        this.posters = builder.posters;
        this.growthGraph = builder.growthGraph;
        this.membersGraph = builder.membersGraph;
        this.newMembersBySourceGraph = builder.newMembersBySourceGraph;
        this.languagesGraph = builder.languagesGraph;
        this.messagesGraph = builder.messagesGraph;
        this.actionsGraph = builder.actionsGraph;
        this.topHoursGraph = builder.topHoursGraph;
        this.weekdaysGraph = builder.weekdaysGraph;
        this.topPosters = ImmutableMegagroupStats.createUnmodifiableList(true, builder.topPosters);
        this.topAdmins = ImmutableMegagroupStats.createUnmodifiableList(true, builder.topAdmins);
        this.topInviters = ImmutableMegagroupStats.createUnmodifiableList(true, builder.topInviters);
        this.users = ImmutableMegagroupStats.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MegagroupStats.super.identifier();
    }

    private ImmutableMegagroupStats(int identifier, StatsDateRangeDays period, StatsAbsValueAndPrev members, StatsAbsValueAndPrev messages, StatsAbsValueAndPrev viewers, StatsAbsValueAndPrev posters, StatsGraph growthGraph, StatsGraph membersGraph, StatsGraph newMembersBySourceGraph, StatsGraph languagesGraph, StatsGraph messagesGraph, StatsGraph actionsGraph, StatsGraph topHoursGraph, StatsGraph weekdaysGraph, List<StatsGroupTopPoster> topPosters, List<StatsGroupTopAdmin> topAdmins, List<StatsGroupTopInviter> topInviters, List<User> users) {
        this.identifier = identifier;
        this.period = period;
        this.members = members;
        this.messages = messages;
        this.viewers = viewers;
        this.posters = posters;
        this.growthGraph = growthGraph;
        this.membersGraph = membersGraph;
        this.newMembersBySourceGraph = newMembersBySourceGraph;
        this.languagesGraph = languagesGraph;
        this.messagesGraph = messagesGraph;
        this.actionsGraph = actionsGraph;
        this.topHoursGraph = topHoursGraph;
        this.weekdaysGraph = weekdaysGraph;
        this.topPosters = topPosters;
        this.topAdmins = topAdmins;
        this.topInviters = topInviters;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StatsDateRangeDays period() {
        return this.period;
    }

    @Override
    public StatsAbsValueAndPrev members() {
        return this.members;
    }

    @Override
    public StatsAbsValueAndPrev messages() {
        return this.messages;
    }

    @Override
    public StatsAbsValueAndPrev viewers() {
        return this.viewers;
    }

    @Override
    public StatsAbsValueAndPrev posters() {
        return this.posters;
    }

    @Override
    public StatsGraph growthGraph() {
        return this.growthGraph;
    }

    @Override
    public StatsGraph membersGraph() {
        return this.membersGraph;
    }

    @Override
    public StatsGraph newMembersBySourceGraph() {
        return this.newMembersBySourceGraph;
    }

    @Override
    public StatsGraph languagesGraph() {
        return this.languagesGraph;
    }

    @Override
    public StatsGraph messagesGraph() {
        return this.messagesGraph;
    }

    @Override
    public StatsGraph actionsGraph() {
        return this.actionsGraph;
    }

    @Override
    public StatsGraph topHoursGraph() {
        return this.topHoursGraph;
    }

    @Override
    public StatsGraph weekdaysGraph() {
        return this.weekdaysGraph;
    }

    @Override
    public List<StatsGroupTopPoster> topPosters() {
        return this.topPosters;
    }

    @Override
    public List<StatsGroupTopAdmin> topAdmins() {
        return this.topAdmins;
    }

    @Override
    public List<StatsGroupTopInviter> topInviters() {
        return this.topInviters;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableMegagroupStats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMegagroupStats(value, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withPeriod(StatsDateRangeDays value) {
        if (this.period == value) {
            return this;
        }
        StatsDateRangeDays newValue = Objects.requireNonNull(value, "period");
        return new ImmutableMegagroupStats(this.identifier, newValue, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withMembers(StatsAbsValueAndPrev value) {
        if (this.members == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "members");
        return new ImmutableMegagroupStats(this.identifier, this.period, newValue, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withMessages(StatsAbsValueAndPrev value) {
        if (this.messages == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "messages");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, newValue, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withViewers(StatsAbsValueAndPrev value) {
        if (this.viewers == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "viewers");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, newValue, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withPosters(StatsAbsValueAndPrev value) {
        if (this.posters == value) {
            return this;
        }
        StatsAbsValueAndPrev newValue = Objects.requireNonNull(value, "posters");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, newValue, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withGrowthGraph(StatsGraph value) {
        if (this.growthGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "growthGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, newValue, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withMembersGraph(StatsGraph value) {
        if (this.membersGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "membersGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, newValue, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withNewMembersBySourceGraph(StatsGraph value) {
        if (this.newMembersBySourceGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "newMembersBySourceGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, newValue, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withLanguagesGraph(StatsGraph value) {
        if (this.languagesGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "languagesGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, newValue, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withMessagesGraph(StatsGraph value) {
        if (this.messagesGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "messagesGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, newValue, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withActionsGraph(StatsGraph value) {
        if (this.actionsGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "actionsGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, newValue, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopHoursGraph(StatsGraph value) {
        if (this.topHoursGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "topHoursGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, newValue, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withWeekdaysGraph(StatsGraph value) {
        if (this.weekdaysGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "weekdaysGraph");
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, newValue, this.topPosters, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopPosters(StatsGroupTopPoster ... elements) {
        List<StatsGroupTopPoster> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, newValue, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopPosters(Iterable<? extends StatsGroupTopPoster> elements) {
        if (this.topPosters == elements) {
            return this;
        }
        List<StatsGroupTopPoster> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(elements, true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, newValue, this.topAdmins, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopAdmins(StatsGroupTopAdmin ... elements) {
        List<StatsGroupTopAdmin> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, newValue, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopAdmins(Iterable<? extends StatsGroupTopAdmin> elements) {
        if (this.topAdmins == elements) {
            return this;
        }
        List<StatsGroupTopAdmin> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(elements, true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, newValue, this.topInviters, this.users);
    }

    public final ImmutableMegagroupStats withTopInviters(StatsGroupTopInviter ... elements) {
        List<StatsGroupTopInviter> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, newValue, this.users);
    }

    public final ImmutableMegagroupStats withTopInviters(Iterable<? extends StatsGroupTopInviter> elements) {
        if (this.topInviters == elements) {
            return this;
        }
        List<StatsGroupTopInviter> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(elements, true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, newValue, this.users);
    }

    public final ImmutableMegagroupStats withUsers(User ... elements) {
        List<User> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, newValue);
    }

    public final ImmutableMegagroupStats withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableMegagroupStats.createUnmodifiableList(false, ImmutableMegagroupStats.createSafeList(elements, true, false));
        return new ImmutableMegagroupStats(this.identifier, this.period, this.members, this.messages, this.viewers, this.posters, this.growthGraph, this.membersGraph, this.newMembersBySourceGraph, this.languagesGraph, this.messagesGraph, this.actionsGraph, this.topHoursGraph, this.weekdaysGraph, this.topPosters, this.topAdmins, this.topInviters, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMegagroupStats && this.equalTo(0, (ImmutableMegagroupStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableMegagroupStats another) {
        return this.identifier == another.identifier && this.period.equals(another.period) && this.members.equals(another.members) && this.messages.equals(another.messages) && this.viewers.equals(another.viewers) && this.posters.equals(another.posters) && this.growthGraph.equals(another.growthGraph) && this.membersGraph.equals(another.membersGraph) && this.newMembersBySourceGraph.equals(another.newMembersBySourceGraph) && this.languagesGraph.equals(another.languagesGraph) && this.messagesGraph.equals(another.messagesGraph) && this.actionsGraph.equals(another.actionsGraph) && this.topHoursGraph.equals(another.topHoursGraph) && this.weekdaysGraph.equals(another.weekdaysGraph) && this.topPosters.equals(another.topPosters) && this.topAdmins.equals(another.topAdmins) && this.topInviters.equals(another.topInviters) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.period.hashCode();
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.viewers.hashCode();
        h += (h << 5) + this.posters.hashCode();
        h += (h << 5) + this.growthGraph.hashCode();
        h += (h << 5) + this.membersGraph.hashCode();
        h += (h << 5) + this.newMembersBySourceGraph.hashCode();
        h += (h << 5) + this.languagesGraph.hashCode();
        h += (h << 5) + this.messagesGraph.hashCode();
        h += (h << 5) + this.actionsGraph.hashCode();
        h += (h << 5) + this.topHoursGraph.hashCode();
        h += (h << 5) + this.weekdaysGraph.hashCode();
        h += (h << 5) + this.topPosters.hashCode();
        h += (h << 5) + this.topAdmins.hashCode();
        h += (h << 5) + this.topInviters.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MegagroupStats{identifier=" + this.identifier + ", period=" + this.period + ", members=" + this.members + ", messages=" + this.messages + ", viewers=" + this.viewers + ", posters=" + this.posters + ", growthGraph=" + this.growthGraph + ", membersGraph=" + this.membersGraph + ", newMembersBySourceGraph=" + this.newMembersBySourceGraph + ", languagesGraph=" + this.languagesGraph + ", messagesGraph=" + this.messagesGraph + ", actionsGraph=" + this.actionsGraph + ", topHoursGraph=" + this.topHoursGraph + ", weekdaysGraph=" + this.weekdaysGraph + ", topPosters=" + this.topPosters + ", topAdmins=" + this.topAdmins + ", topInviters=" + this.topInviters + ", users=" + this.users + "}";
    }

    public static ImmutableMegagroupStats of(StatsDateRangeDays period, StatsAbsValueAndPrev members, StatsAbsValueAndPrev messages, StatsAbsValueAndPrev viewers, StatsAbsValueAndPrev posters, StatsGraph growthGraph, StatsGraph membersGraph, StatsGraph newMembersBySourceGraph, StatsGraph languagesGraph, StatsGraph messagesGraph, StatsGraph actionsGraph, StatsGraph topHoursGraph, StatsGraph weekdaysGraph) {
        return new ImmutableMegagroupStats(period, members, messages, viewers, posters, growthGraph, membersGraph, newMembersBySourceGraph, languagesGraph, messagesGraph, actionsGraph, topHoursGraph, weekdaysGraph);
    }

    public static ImmutableMegagroupStats copyOf(MegagroupStats instance) {
        if (instance instanceof ImmutableMegagroupStats) {
            return (ImmutableMegagroupStats)instance;
        }
        return ImmutableMegagroupStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PERIOD = 1L;
        private static final long INIT_BIT_MEMBERS = 2L;
        private static final long INIT_BIT_MESSAGES = 4L;
        private static final long INIT_BIT_VIEWERS = 8L;
        private static final long INIT_BIT_POSTERS = 16L;
        private static final long INIT_BIT_GROWTH_GRAPH = 32L;
        private static final long INIT_BIT_MEMBERS_GRAPH = 64L;
        private static final long INIT_BIT_NEW_MEMBERS_BY_SOURCE_GRAPH = 128L;
        private static final long INIT_BIT_LANGUAGES_GRAPH = 256L;
        private static final long INIT_BIT_MESSAGES_GRAPH = 512L;
        private static final long INIT_BIT_ACTIONS_GRAPH = 1024L;
        private static final long INIT_BIT_TOP_HOURS_GRAPH = 2048L;
        private static final long INIT_BIT_WEEKDAYS_GRAPH = 4096L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 8191L;
        private long optBits;
        private int identifier;
        private StatsDateRangeDays period;
        private StatsAbsValueAndPrev members;
        private StatsAbsValueAndPrev messages;
        private StatsAbsValueAndPrev viewers;
        private StatsAbsValueAndPrev posters;
        private StatsGraph growthGraph;
        private StatsGraph membersGraph;
        private StatsGraph newMembersBySourceGraph;
        private StatsGraph languagesGraph;
        private StatsGraph messagesGraph;
        private StatsGraph actionsGraph;
        private StatsGraph topHoursGraph;
        private StatsGraph weekdaysGraph;
        private List<StatsGroupTopPoster> topPosters = new ArrayList<StatsGroupTopPoster>();
        private List<StatsGroupTopAdmin> topAdmins = new ArrayList<StatsGroupTopAdmin>();
        private List<StatsGroupTopInviter> topInviters = new ArrayList<StatsGroupTopInviter>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(MegagroupStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MegagroupStats instance;
            long bits = 0L;
            if (object instanceof MegagroupStats) {
                instance = (MegagroupStats)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
                this.languagesGraph(instance.languagesGraph());
                this.topHoursGraph(instance.topHoursGraph());
                this.weekdaysGraph(instance.weekdaysGraph());
                this.newMembersBySourceGraph(instance.newMembersBySourceGraph());
                this.addAllTopAdmins(instance.topAdmins());
                this.posters(instance.posters());
                this.addAllUsers(instance.users());
                this.addAllTopPosters(instance.topPosters());
                this.viewers(instance.viewers());
                this.messagesGraph(instance.messagesGraph());
                this.actionsGraph(instance.actionsGraph());
                this.members(instance.members());
                this.membersGraph(instance.membersGraph());
                this.messages(instance.messages());
                this.addAllTopInviters(instance.topInviters());
                this.growthGraph(instance.growthGraph());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder period(StatsDateRangeDays period) {
            this.period = Objects.requireNonNull(period, "period");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder members(StatsAbsValueAndPrev members) {
            this.members = Objects.requireNonNull(members, "members");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder messages(StatsAbsValueAndPrev messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder viewers(StatsAbsValueAndPrev viewers) {
            this.viewers = Objects.requireNonNull(viewers, "viewers");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder posters(StatsAbsValueAndPrev posters) {
            this.posters = Objects.requireNonNull(posters, "posters");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder growthGraph(StatsGraph growthGraph) {
            this.growthGraph = Objects.requireNonNull(growthGraph, "growthGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder membersGraph(StatsGraph membersGraph) {
            this.membersGraph = Objects.requireNonNull(membersGraph, "membersGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder newMembersBySourceGraph(StatsGraph newMembersBySourceGraph) {
            this.newMembersBySourceGraph = Objects.requireNonNull(newMembersBySourceGraph, "newMembersBySourceGraph");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder languagesGraph(StatsGraph languagesGraph) {
            this.languagesGraph = Objects.requireNonNull(languagesGraph, "languagesGraph");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder messagesGraph(StatsGraph messagesGraph) {
            this.messagesGraph = Objects.requireNonNull(messagesGraph, "messagesGraph");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder actionsGraph(StatsGraph actionsGraph) {
            this.actionsGraph = Objects.requireNonNull(actionsGraph, "actionsGraph");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder topHoursGraph(StatsGraph topHoursGraph) {
            this.topHoursGraph = Objects.requireNonNull(topHoursGraph, "topHoursGraph");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder weekdaysGraph(StatsGraph weekdaysGraph) {
            this.weekdaysGraph = Objects.requireNonNull(weekdaysGraph, "weekdaysGraph");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder addTopPoster(StatsGroupTopPoster element) {
            this.topPosters.add(Objects.requireNonNull(element, "topPosters element"));
            return this;
        }

        public final Builder addTopPosters(StatsGroupTopPoster ... elements) {
            for (StatsGroupTopPoster element : elements) {
                this.topPosters.add(Objects.requireNonNull(element, "topPosters element"));
            }
            return this;
        }

        public final Builder topPosters(Iterable<? extends StatsGroupTopPoster> elements) {
            this.topPosters.clear();
            return this.addAllTopPosters(elements);
        }

        public final Builder addAllTopPosters(Iterable<? extends StatsGroupTopPoster> elements) {
            for (StatsGroupTopPoster statsGroupTopPoster : elements) {
                this.topPosters.add(Objects.requireNonNull(statsGroupTopPoster, "topPosters element"));
            }
            return this;
        }

        public final Builder addTopAdmin(StatsGroupTopAdmin element) {
            this.topAdmins.add(Objects.requireNonNull(element, "topAdmins element"));
            return this;
        }

        public final Builder addTopAdmins(StatsGroupTopAdmin ... elements) {
            for (StatsGroupTopAdmin element : elements) {
                this.topAdmins.add(Objects.requireNonNull(element, "topAdmins element"));
            }
            return this;
        }

        public final Builder topAdmins(Iterable<? extends StatsGroupTopAdmin> elements) {
            this.topAdmins.clear();
            return this.addAllTopAdmins(elements);
        }

        public final Builder addAllTopAdmins(Iterable<? extends StatsGroupTopAdmin> elements) {
            for (StatsGroupTopAdmin statsGroupTopAdmin : elements) {
                this.topAdmins.add(Objects.requireNonNull(statsGroupTopAdmin, "topAdmins element"));
            }
            return this;
        }

        public final Builder addTopInviter(StatsGroupTopInviter element) {
            this.topInviters.add(Objects.requireNonNull(element, "topInviters element"));
            return this;
        }

        public final Builder addTopInviters(StatsGroupTopInviter ... elements) {
            for (StatsGroupTopInviter element : elements) {
                this.topInviters.add(Objects.requireNonNull(element, "topInviters element"));
            }
            return this;
        }

        public final Builder topInviters(Iterable<? extends StatsGroupTopInviter> elements) {
            this.topInviters.clear();
            return this.addAllTopInviters(elements);
        }

        public final Builder addAllTopInviters(Iterable<? extends StatsGroupTopInviter> elements) {
            for (StatsGroupTopInviter statsGroupTopInviter : elements) {
                this.topInviters.add(Objects.requireNonNull(statsGroupTopInviter, "topInviters element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableMegagroupStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMegagroupStats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("period");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("members");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("messages");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("viewers");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("posters");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("growthGraph");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("membersGraph");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("newMembersBySourceGraph");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("languagesGraph");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("messagesGraph");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("actionsGraph");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("topHoursGraph");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("weekdaysGraph");
            }
            return "Cannot build MegagroupStats, some of required attributes are not set " + attributes;
        }
    }
}

