/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.stats;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.stats.MessageStats;

public final class ImmutableMessageStats
implements MessageStats {
    private final int identifier;
    private final StatsGraph viewsGraph;

    private ImmutableMessageStats(StatsGraph viewsGraph) {
        this.viewsGraph = Objects.requireNonNull(viewsGraph, "viewsGraph");
        this.identifier = MessageStats.super.identifier();
    }

    private ImmutableMessageStats(Builder builder) {
        this.viewsGraph = builder.viewsGraph;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageStats.super.identifier();
    }

    private ImmutableMessageStats(int identifier, StatsGraph viewsGraph) {
        this.identifier = identifier;
        this.viewsGraph = viewsGraph;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StatsGraph viewsGraph() {
        return this.viewsGraph;
    }

    public final ImmutableMessageStats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageStats(value, this.viewsGraph);
    }

    public final ImmutableMessageStats withViewsGraph(StatsGraph value) {
        if (this.viewsGraph == value) {
            return this;
        }
        StatsGraph newValue = Objects.requireNonNull(value, "viewsGraph");
        return new ImmutableMessageStats(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageStats && this.equalTo(0, (ImmutableMessageStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageStats another) {
        return this.identifier == another.identifier && this.viewsGraph.equals(another.viewsGraph);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.viewsGraph.hashCode();
        return h;
    }

    public String toString() {
        return "MessageStats{identifier=" + this.identifier + ", viewsGraph=" + this.viewsGraph + "}";
    }

    public static ImmutableMessageStats of(StatsGraph viewsGraph) {
        return new ImmutableMessageStats(viewsGraph);
    }

    public static ImmutableMessageStats copyOf(MessageStats instance) {
        if (instance instanceof ImmutableMessageStats) {
            return (ImmutableMessageStats)instance;
        }
        return ImmutableMessageStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VIEWS_GRAPH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private StatsGraph viewsGraph;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageStats) {
                instance = (MessageStats)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.viewsGraph(instance.viewsGraph());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder viewsGraph(StatsGraph viewsGraph) {
            this.viewsGraph = Objects.requireNonNull(viewsGraph, "viewsGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageStats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("viewsGraph");
            }
            return "Cannot build MessageStats, some of required attributes are not set " + attributes;
        }
    }
}

