/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Message;
import telegram4j.tl.Update;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.BaseChannelDifference;
import telegram4j.tl.updates.ChannelDifference;

public final class ImmutableBaseChannelDifference
implements BaseChannelDifference {
    private final int identifier;
    private final int flags;
    private final boolean isFinal;
    private final int pts;
    @Nullable
    private final Integer timeout;
    private final List<Message> newMessages;
    private final List<Update> otherUpdates;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseChannelDifference(int pts) {
        this.pts = pts;
        this.timeout = null;
        this.newMessages = Collections.emptyList();
        this.otherUpdates = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableBaseChannelDifference(Builder builder) {
        this.pts = builder.pts;
        this.timeout = builder.timeout;
        this.newMessages = ImmutableBaseChannelDifference.createUnmodifiableList(true, builder.newMessages);
        this.otherUpdates = ImmutableBaseChannelDifference.createUnmodifiableList(true, builder.otherUpdates);
        this.chats = ImmutableBaseChannelDifference.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseChannelDifference.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.isFinalIsSet()) {
            this.initShim.isFinal(builder.isFinal);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableBaseChannelDifference(int identifier, int flags, boolean isFinal, int pts, @Nullable Integer timeout, List<Message> newMessages, List<Update> otherUpdates, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.isFinal = isFinal;
        this.pts = pts;
        this.timeout = timeout;
        this.newMessages = newMessages;
        this.otherUpdates = otherUpdates;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseChannelDifference.super.identifier();
    }

    private int flagsInitialize() {
        return BaseChannelDifference.super.flags();
    }

    private boolean isFinalInitialize() {
        return BaseChannelDifference.super.isFinal();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean isFinal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFinal() : this.isFinal;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    @Nullable
    public Integer timeout() {
        return this.timeout;
    }

    @Override
    public List<Message> newMessages() {
        return this.newMessages;
    }

    @Override
    public List<Update> otherUpdates() {
        return this.otherUpdates;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseChannelDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChannelDifference(value, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseChannelDifference(this.identifier, value, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withIsFinal(boolean value) {
        if (this.isFinal == value) {
            return this;
        }
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, value, this.pts, this.timeout, this.newMessages, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, value, this.timeout, this.newMessages, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withTimeout(@Nullable Integer value) {
        if (Objects.equals(this.timeout, value)) {
            return this;
        }
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, value, this.newMessages, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withNewMessages(Message ... elements) {
        List<Message> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, newValue, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withNewMessages(Iterable<? extends Message> elements) {
        if (this.newMessages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(elements, true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, newValue, this.otherUpdates, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withOtherUpdates(Update ... elements) {
        List<Update> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, newValue, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withOtherUpdates(Iterable<? extends Update> elements) {
        if (this.otherUpdates == elements) {
            return this;
        }
        List<Update> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(elements, true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, newValue, this.chats, this.users);
    }

    public final ImmutableBaseChannelDifference withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, newValue, this.users);
    }

    public final ImmutableBaseChannelDifference withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(elements, true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, newValue, this.users);
    }

    public final ImmutableBaseChannelDifference withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, this.chats, newValue);
    }

    public final ImmutableBaseChannelDifference withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseChannelDifference.createUnmodifiableList(false, ImmutableBaseChannelDifference.createSafeList(elements, true, false));
        return new ImmutableBaseChannelDifference(this.identifier, this.flags, this.isFinal, this.pts, this.timeout, this.newMessages, this.otherUpdates, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChannelDifference && this.equalTo(0, (ImmutableBaseChannelDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChannelDifference another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.isFinal == another.isFinal && this.pts == another.pts && Objects.equals(this.timeout, another.timeout) && this.newMessages.equals(another.newMessages) && this.otherUpdates.equals(another.otherUpdates) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.isFinal);
        h += (h << 5) + this.pts;
        h += (h << 5) + Objects.hashCode(this.timeout);
        h += (h << 5) + this.newMessages.hashCode();
        h += (h << 5) + this.otherUpdates.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseChannelDifference{identifier=" + this.identifier + ", flags=" + this.flags + ", isFinal=" + this.isFinal + ", pts=" + this.pts + ", timeout=" + this.timeout + ", newMessages=" + this.newMessages + ", otherUpdates=" + this.otherUpdates + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBaseChannelDifference of(int pts) {
        return new ImmutableBaseChannelDifference(pts);
    }

    public static ImmutableBaseChannelDifference copyOf(BaseChannelDifference instance) {
        if (instance instanceof ImmutableBaseChannelDifference) {
            return (ImmutableBaseChannelDifference)instance;
        }
        return ImmutableBaseChannelDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IS_FINAL = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean isFinal;
        private int pts;
        private Integer timeout;
        private List<Message> newMessages = new ArrayList<Message>();
        private List<Update> otherUpdates = new ArrayList<Update>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(BaseChannelDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer timeoutValue;
            ChannelDifference instance;
            long bits = 0L;
            if (object instanceof BaseChannelDifference) {
                instance = (BaseChannelDifference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllNewMessages(instance.newMessages());
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                this.addAllOtherUpdates(instance.otherUpdates());
                this.addAllChats(instance.chats());
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                this.pts(instance.pts());
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelDifference) {
                instance = (ChannelDifference)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.optBits |= 4L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Builder addNewMessage(Message element) {
            this.newMessages.add(Objects.requireNonNull(element, "newMessages element"));
            return this;
        }

        public final Builder addNewMessages(Message ... elements) {
            for (Message element : elements) {
                this.newMessages.add(Objects.requireNonNull(element, "newMessages element"));
            }
            return this;
        }

        public final Builder newMessages(Iterable<? extends Message> elements) {
            this.newMessages.clear();
            return this.addAllNewMessages(elements);
        }

        public final Builder addAllNewMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.newMessages.add(Objects.requireNonNull(message, "newMessages element"));
            }
            return this;
        }

        public final Builder addOtherUpdate(Update element) {
            this.otherUpdates.add(Objects.requireNonNull(element, "otherUpdates element"));
            return this;
        }

        public final Builder addOtherUpdates(Update ... elements) {
            for (Update element : elements) {
                this.otherUpdates.add(Objects.requireNonNull(element, "otherUpdates element"));
            }
            return this;
        }

        public final Builder otherUpdates(Iterable<? extends Update> elements) {
            this.otherUpdates.clear();
            return this.addAllOtherUpdates(elements);
        }

        public final Builder addAllOtherUpdates(Iterable<? extends Update> elements) {
            for (Update update : elements) {
                this.otherUpdates.add(Objects.requireNonNull(update, "otherUpdates element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseChannelDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChannelDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isFinalIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            return "Cannot build BaseChannelDifference, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte isFinalBuildStage = 0;
        private boolean isFinal;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseChannelDifference.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseChannelDifference.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean isFinal() {
            if (this.isFinalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFinalBuildStage == 0) {
                this.isFinalBuildStage = (byte)-1;
                this.isFinal = ImmutableBaseChannelDifference.this.isFinalInitialize();
                this.isFinalBuildStage = 1;
            }
            return this.isFinal;
        }

        void isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.isFinalBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.isFinalBuildStage == -1) {
                attributes.add("isFinal");
            }
            return "Cannot build BaseChannelDifference, attribute initializers form cycle " + attributes;
        }
    }
}

