/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.EncryptedMessage;
import telegram4j.tl.Message;
import telegram4j.tl.Update;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.BaseDifference;
import telegram4j.tl.updates.Difference;
import telegram4j.tl.updates.State;

public final class ImmutableBaseDifference
implements BaseDifference {
    private final int identifier;
    private final List<Message> newMessages;
    private final List<EncryptedMessage> newEncryptedMessages;
    private final List<Update> otherUpdates;
    private final List<Chat> chats;
    private final List<User> users;
    private final State state;

    private ImmutableBaseDifference(State state) {
        this.state = Objects.requireNonNull(state, "state");
        this.newMessages = Collections.emptyList();
        this.newEncryptedMessages = Collections.emptyList();
        this.otherUpdates = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = BaseDifference.super.identifier();
    }

    private ImmutableBaseDifference(Builder builder) {
        this.newMessages = ImmutableBaseDifference.createUnmodifiableList(true, builder.newMessages);
        this.newEncryptedMessages = ImmutableBaseDifference.createUnmodifiableList(true, builder.newEncryptedMessages);
        this.otherUpdates = ImmutableBaseDifference.createUnmodifiableList(true, builder.otherUpdates);
        this.chats = ImmutableBaseDifference.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseDifference.createUnmodifiableList(true, builder.users);
        this.state = builder.state;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseDifference.super.identifier();
    }

    private ImmutableBaseDifference(int identifier, List<Message> newMessages, List<EncryptedMessage> newEncryptedMessages, List<Update> otherUpdates, List<Chat> chats, List<User> users, State state) {
        this.identifier = identifier;
        this.newMessages = newMessages;
        this.newEncryptedMessages = newEncryptedMessages;
        this.otherUpdates = otherUpdates;
        this.chats = chats;
        this.users = users;
        this.state = state;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Message> newMessages() {
        return this.newMessages;
    }

    @Override
    public List<EncryptedMessage> newEncryptedMessages() {
        return this.newEncryptedMessages;
    }

    @Override
    public List<Update> otherUpdates() {
        return this.otherUpdates;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    public State state() {
        return this.state;
    }

    public final ImmutableBaseDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDifference(value, this.newMessages, this.newEncryptedMessages, this.otherUpdates, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withNewMessages(Message ... elements) {
        List<Message> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDifference(this.identifier, newValue, this.newEncryptedMessages, this.otherUpdates, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withNewMessages(Iterable<? extends Message> elements) {
        if (this.newMessages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(elements, true, false));
        return new ImmutableBaseDifference(this.identifier, newValue, this.newEncryptedMessages, this.otherUpdates, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withNewEncryptedMessages(EncryptedMessage ... elements) {
        List<EncryptedMessage> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, newValue, this.otherUpdates, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withNewEncryptedMessages(Iterable<? extends EncryptedMessage> elements) {
        if (this.newEncryptedMessages == elements) {
            return this;
        }
        List<EncryptedMessage> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(elements, true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, newValue, this.otherUpdates, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withOtherUpdates(Update ... elements) {
        List<Update> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, newValue, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withOtherUpdates(Iterable<? extends Update> elements) {
        if (this.otherUpdates == elements) {
            return this;
        }
        List<Update> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(elements, true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, newValue, this.chats, this.users, this.state);
    }

    public final ImmutableBaseDifference withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, this.otherUpdates, newValue, this.users, this.state);
    }

    public final ImmutableBaseDifference withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(elements, true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, this.otherUpdates, newValue, this.users, this.state);
    }

    public final ImmutableBaseDifference withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, this.otherUpdates, this.chats, newValue, this.state);
    }

    public final ImmutableBaseDifference withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseDifference.createUnmodifiableList(false, ImmutableBaseDifference.createSafeList(elements, true, false));
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, this.otherUpdates, this.chats, newValue, this.state);
    }

    public final ImmutableBaseDifference withState(State value) {
        if (this.state == value) {
            return this;
        }
        State newValue = Objects.requireNonNull(value, "state");
        return new ImmutableBaseDifference(this.identifier, this.newMessages, this.newEncryptedMessages, this.otherUpdates, this.chats, this.users, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDifference && this.equalTo(0, (ImmutableBaseDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDifference another) {
        return this.identifier == another.identifier && this.newMessages.equals(another.newMessages) && this.newEncryptedMessages.equals(another.newEncryptedMessages) && this.otherUpdates.equals(another.otherUpdates) && this.chats.equals(another.chats) && this.users.equals(another.users) && this.state.equals(another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.newMessages.hashCode();
        h += (h << 5) + this.newEncryptedMessages.hashCode();
        h += (h << 5) + this.otherUpdates.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.state.hashCode();
        return h;
    }

    public String toString() {
        return "BaseDifference{identifier=" + this.identifier + ", newMessages=" + this.newMessages + ", newEncryptedMessages=" + this.newEncryptedMessages + ", otherUpdates=" + this.otherUpdates + ", chats=" + this.chats + ", users=" + this.users + ", state=" + this.state + "}";
    }

    public static ImmutableBaseDifference of(State state) {
        return new ImmutableBaseDifference(state);
    }

    public static ImmutableBaseDifference copyOf(BaseDifference instance) {
        if (instance instanceof ImmutableBaseDifference) {
            return (ImmutableBaseDifference)instance;
        }
        return ImmutableBaseDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<Message> newMessages = new ArrayList<Message>();
        private List<EncryptedMessage> newEncryptedMessages = new ArrayList<EncryptedMessage>();
        private List<Update> otherUpdates = new ArrayList<Update>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();
        private State state;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Difference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Difference) {
                instance = (Difference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseDifference) {
                instance = (BaseDifference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllNewMessages(instance.newMessages());
                this.addAllNewEncryptedMessages(instance.newEncryptedMessages());
                this.addAllOtherUpdates(instance.otherUpdates());
                this.addAllChats(instance.chats());
                this.state(instance.state());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addNewMessage(Message element) {
            this.newMessages.add(Objects.requireNonNull(element, "newMessages element"));
            return this;
        }

        public final Builder addNewMessages(Message ... elements) {
            for (Message element : elements) {
                this.newMessages.add(Objects.requireNonNull(element, "newMessages element"));
            }
            return this;
        }

        public final Builder newMessages(Iterable<? extends Message> elements) {
            this.newMessages.clear();
            return this.addAllNewMessages(elements);
        }

        public final Builder addAllNewMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.newMessages.add(Objects.requireNonNull(message, "newMessages element"));
            }
            return this;
        }

        public final Builder addNewEncryptedMessage(EncryptedMessage element) {
            this.newEncryptedMessages.add(Objects.requireNonNull(element, "newEncryptedMessages element"));
            return this;
        }

        public final Builder addNewEncryptedMessages(EncryptedMessage ... elements) {
            for (EncryptedMessage element : elements) {
                this.newEncryptedMessages.add(Objects.requireNonNull(element, "newEncryptedMessages element"));
            }
            return this;
        }

        public final Builder newEncryptedMessages(Iterable<? extends EncryptedMessage> elements) {
            this.newEncryptedMessages.clear();
            return this.addAllNewEncryptedMessages(elements);
        }

        public final Builder addAllNewEncryptedMessages(Iterable<? extends EncryptedMessage> elements) {
            for (EncryptedMessage encryptedMessage : elements) {
                this.newEncryptedMessages.add(Objects.requireNonNull(encryptedMessage, "newEncryptedMessages element"));
            }
            return this;
        }

        public final Builder addOtherUpdate(Update element) {
            this.otherUpdates.add(Objects.requireNonNull(element, "otherUpdates element"));
            return this;
        }

        public final Builder addOtherUpdates(Update ... elements) {
            for (Update element : elements) {
                this.otherUpdates.add(Objects.requireNonNull(element, "otherUpdates element"));
            }
            return this;
        }

        public final Builder otherUpdates(Iterable<? extends Update> elements) {
            this.otherUpdates.clear();
            return this.addAllOtherUpdates(elements);
        }

        public final Builder addAllOtherUpdates(Iterable<? extends Update> elements) {
            for (Update update : elements) {
                this.otherUpdates.add(Objects.requireNonNull(update, "otherUpdates element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder state(State state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build BaseDifference, some of required attributes are not set " + attributes;
        }
    }
}

