/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.ChannelDifference;
import telegram4j.tl.updates.ChannelDifferenceEmpty;

public final class ImmutableChannelDifferenceEmpty
implements ChannelDifferenceEmpty {
    private final int identifier;
    private final int flags;
    private final boolean isFinal;
    private final int pts;
    @Nullable
    private final Integer timeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelDifferenceEmpty(int pts) {
        this.pts = pts;
        this.timeout = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableChannelDifferenceEmpty(Builder builder) {
        this.pts = builder.pts;
        this.timeout = builder.timeout;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.isFinalIsSet()) {
            this.initShim.isFinal(builder.isFinal);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableChannelDifferenceEmpty(int identifier, int flags, boolean isFinal, int pts, @Nullable Integer timeout) {
        this.identifier = identifier;
        this.flags = flags;
        this.isFinal = isFinal;
        this.pts = pts;
        this.timeout = timeout;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelDifferenceEmpty.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelDifferenceEmpty.super.flags();
    }

    private boolean isFinalInitialize() {
        return ChannelDifferenceEmpty.super.isFinal();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean isFinal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFinal() : this.isFinal;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    @Nullable
    public Integer timeout() {
        return this.timeout;
    }

    public final ImmutableChannelDifferenceEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelDifferenceEmpty(value, this.flags, this.isFinal, this.pts, this.timeout);
    }

    public final ImmutableChannelDifferenceEmpty withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelDifferenceEmpty(this.identifier, value, this.isFinal, this.pts, this.timeout);
    }

    public final ImmutableChannelDifferenceEmpty withIsFinal(boolean value) {
        if (this.isFinal == value) {
            return this;
        }
        return new ImmutableChannelDifferenceEmpty(this.identifier, this.flags, value, this.pts, this.timeout);
    }

    public final ImmutableChannelDifferenceEmpty withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableChannelDifferenceEmpty(this.identifier, this.flags, this.isFinal, value, this.timeout);
    }

    public final ImmutableChannelDifferenceEmpty withTimeout(@Nullable Integer value) {
        if (Objects.equals(this.timeout, value)) {
            return this;
        }
        return new ImmutableChannelDifferenceEmpty(this.identifier, this.flags, this.isFinal, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelDifferenceEmpty && this.equalTo(0, (ImmutableChannelDifferenceEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelDifferenceEmpty another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.isFinal == another.isFinal && this.pts == another.pts && Objects.equals(this.timeout, another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.isFinal);
        h += (h << 5) + this.pts;
        h += (h << 5) + Objects.hashCode(this.timeout);
        return h;
    }

    public String toString() {
        return "ChannelDifferenceEmpty{identifier=" + this.identifier + ", flags=" + this.flags + ", isFinal=" + this.isFinal + ", pts=" + this.pts + ", timeout=" + this.timeout + "}";
    }

    public static ImmutableChannelDifferenceEmpty of(int pts) {
        return new ImmutableChannelDifferenceEmpty(pts);
    }

    public static ImmutableChannelDifferenceEmpty copyOf(ChannelDifferenceEmpty instance) {
        if (instance instanceof ImmutableChannelDifferenceEmpty) {
            return (ImmutableChannelDifferenceEmpty)instance;
        }
        return ImmutableChannelDifferenceEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IS_FINAL = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean isFinal;
        private int pts;
        private Integer timeout;

        private Builder() {
        }

        public final Builder from(ChannelDifferenceEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer timeoutValue;
            ChannelDifference instance;
            long bits = 0L;
            if (object instanceof ChannelDifferenceEmpty) {
                instance = (ChannelDifferenceEmpty)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                this.pts(instance.pts());
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelDifference) {
                instance = (ChannelDifference)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.optBits |= 4L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ImmutableChannelDifferenceEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelDifferenceEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isFinalIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            return "Cannot build ChannelDifferenceEmpty, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte isFinalBuildStage = 0;
        private boolean isFinal;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelDifferenceEmpty.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelDifferenceEmpty.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean isFinal() {
            if (this.isFinalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFinalBuildStage == 0) {
                this.isFinalBuildStage = (byte)-1;
                this.isFinal = ImmutableChannelDifferenceEmpty.this.isFinalInitialize();
                this.isFinalBuildStage = 1;
            }
            return this.isFinal;
        }

        void isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.isFinalBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.isFinalBuildStage == -1) {
                attributes.add("isFinal");
            }
            return "Cannot build ChannelDifferenceEmpty, attribute initializers form cycle " + attributes;
        }
    }
}

