/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Dialog;
import telegram4j.tl.Message;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.ChannelDifference;
import telegram4j.tl.updates.ChannelDifferenceTooLong;

public final class ImmutableChannelDifferenceTooLong
implements ChannelDifferenceTooLong {
    private final int identifier;
    private final int flags;
    private final boolean isFinal;
    @Nullable
    private final Integer timeout;
    private final Dialog dialog;
    private final List<Message> messages;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelDifferenceTooLong(Dialog dialog) {
        this.dialog = Objects.requireNonNull(dialog, "dialog");
        this.timeout = null;
        this.messages = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableChannelDifferenceTooLong(Builder builder) {
        this.timeout = builder.timeout;
        this.dialog = builder.dialog;
        this.messages = ImmutableChannelDifferenceTooLong.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableChannelDifferenceTooLong.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableChannelDifferenceTooLong.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.isFinalIsSet()) {
            this.initShim.isFinal(builder.isFinal);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isFinal = this.initShim.isFinal();
        this.initShim = null;
    }

    private ImmutableChannelDifferenceTooLong(int identifier, int flags, boolean isFinal, @Nullable Integer timeout, Dialog dialog, List<Message> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.isFinal = isFinal;
        this.timeout = timeout;
        this.dialog = dialog;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelDifferenceTooLong.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelDifferenceTooLong.super.flags();
    }

    private boolean isFinalInitialize() {
        return ChannelDifferenceTooLong.super.isFinal();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean isFinal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFinal() : this.isFinal;
    }

    @Override
    @Nullable
    public Integer timeout() {
        return this.timeout;
    }

    @Override
    public Dialog dialog() {
        return this.dialog;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChannelDifferenceTooLong withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelDifferenceTooLong(value, this.flags, this.isFinal, this.timeout, this.dialog, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelDifferenceTooLong(this.identifier, value, this.isFinal, this.timeout, this.dialog, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withIsFinal(boolean value) {
        if (this.isFinal == value) {
            return this;
        }
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, value, this.timeout, this.dialog, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withTimeout(@Nullable Integer value) {
        if (Objects.equals(this.timeout, value)) {
            return this;
        }
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, value, this.dialog, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withDialog(Dialog value) {
        if (this.dialog == value) {
            return this;
        }
        Dialog newValue = Objects.requireNonNull(value, "dialog");
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, newValue, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withMessages(Message ... elements) {
        List<Message> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, newValue, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(elements, true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, newValue, this.chats, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, this.messages, newValue, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(elements, true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, this.messages, newValue, this.users);
    }

    public final ImmutableChannelDifferenceTooLong withUsers(User ... elements) {
        List<User> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, this.messages, this.chats, newValue);
    }

    public final ImmutableChannelDifferenceTooLong withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChannelDifferenceTooLong.createUnmodifiableList(false, ImmutableChannelDifferenceTooLong.createSafeList(elements, true, false));
        return new ImmutableChannelDifferenceTooLong(this.identifier, this.flags, this.isFinal, this.timeout, this.dialog, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelDifferenceTooLong && this.equalTo(0, (ImmutableChannelDifferenceTooLong)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelDifferenceTooLong another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.isFinal == another.isFinal && Objects.equals(this.timeout, another.timeout) && this.dialog.equals(another.dialog) && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.isFinal);
        h += (h << 5) + Objects.hashCode(this.timeout);
        h += (h << 5) + this.dialog.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelDifferenceTooLong{identifier=" + this.identifier + ", flags=" + this.flags + ", isFinal=" + this.isFinal + ", timeout=" + this.timeout + ", dialog=" + this.dialog + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableChannelDifferenceTooLong of(Dialog dialog) {
        return new ImmutableChannelDifferenceTooLong(dialog);
    }

    public static ImmutableChannelDifferenceTooLong copyOf(ChannelDifferenceTooLong instance) {
        if (instance instanceof ImmutableChannelDifferenceTooLong) {
            return (ImmutableChannelDifferenceTooLong)instance;
        }
        return ImmutableChannelDifferenceTooLong.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DIALOG = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IS_FINAL = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean isFinal;
        private Integer timeout;
        private Dialog dialog;
        private List<Message> messages = new ArrayList<Message>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelDifferenceTooLong instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer timeoutValue;
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelDifference) {
                instance = (ChannelDifference)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof ChannelDifferenceTooLong) {
                instance = (ChannelDifferenceTooLong)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.dialog(instance.dialog());
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                this.addAllChats(instance.chats());
                this.addAllMessages(instance.messages());
                if ((bits & 4L) == 0L) {
                    this.isFinal(instance.isFinal());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    timeoutValue = instance.timeout();
                    if (timeoutValue != null) {
                        this.timeout(timeoutValue);
                    }
                    bits |= 8L;
                }
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.optBits |= 4L;
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Builder dialog(Dialog dialog) {
            this.dialog = Objects.requireNonNull(dialog, "dialog");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChannelDifferenceTooLong build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelDifferenceTooLong(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isFinalIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dialog");
            }
            return "Cannot build ChannelDifferenceTooLong, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte isFinalBuildStage = 0;
        private boolean isFinal;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelDifferenceTooLong.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelDifferenceTooLong.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean isFinal() {
            if (this.isFinalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFinalBuildStage == 0) {
                this.isFinalBuildStage = (byte)-1;
                this.isFinal = ImmutableChannelDifferenceTooLong.this.isFinalInitialize();
                this.isFinalBuildStage = 1;
            }
            return this.isFinal;
        }

        void isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            this.isFinalBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.isFinalBuildStage == -1) {
                attributes.add("isFinal");
            }
            return "Cannot build ChannelDifferenceTooLong, attribute initializers form cycle " + attributes;
        }
    }
}

