/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.Difference;
import telegram4j.tl.updates.DifferenceEmpty;

public final class ImmutableDifferenceEmpty
implements DifferenceEmpty {
    private final int identifier;
    private final int date;
    private final int seq;

    private ImmutableDifferenceEmpty(int date, int seq) {
        this.date = date;
        this.seq = seq;
        this.identifier = DifferenceEmpty.super.identifier();
    }

    private ImmutableDifferenceEmpty(Builder builder) {
        this.date = builder.date;
        this.seq = builder.seq;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DifferenceEmpty.super.identifier();
    }

    private ImmutableDifferenceEmpty(int identifier, int date, int seq) {
        this.identifier = identifier;
        this.date = date;
        this.seq = seq;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int seq() {
        return this.seq;
    }

    public final ImmutableDifferenceEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDifferenceEmpty(value, this.date, this.seq);
    }

    public final ImmutableDifferenceEmpty withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableDifferenceEmpty(this.identifier, value, this.seq);
    }

    public final ImmutableDifferenceEmpty withSeq(int value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableDifferenceEmpty(this.identifier, this.date, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDifferenceEmpty && this.equalTo(0, (ImmutableDifferenceEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableDifferenceEmpty another) {
        return this.identifier == another.identifier && this.date == another.date && this.seq == another.seq;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.date;
        h += (h << 5) + this.seq;
        return h;
    }

    public String toString() {
        return "DifferenceEmpty{identifier=" + this.identifier + ", date=" + this.date + ", seq=" + this.seq + "}";
    }

    public static ImmutableDifferenceEmpty of(int date, int seq) {
        return new ImmutableDifferenceEmpty(date, seq);
    }

    public static ImmutableDifferenceEmpty copyOf(DifferenceEmpty instance) {
        if (instance instanceof ImmutableDifferenceEmpty) {
            return (ImmutableDifferenceEmpty)instance;
        }
        return ImmutableDifferenceEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int date;
        private int seq;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DifferenceEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Difference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DifferenceEmpty) {
                instance = (DifferenceEmpty)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.seq(instance.seq());
            }
            if (object instanceof Difference) {
                instance = (Difference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seq(int seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDifferenceEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDifferenceEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            return "Cannot build DifferenceEmpty, some of required attributes are not set " + attributes;
        }
    }
}

