/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.Difference;
import telegram4j.tl.updates.DifferenceTooLong;

public final class ImmutableDifferenceTooLong
implements DifferenceTooLong {
    private final int identifier;
    private final int pts;

    private ImmutableDifferenceTooLong(int pts) {
        this.pts = pts;
        this.identifier = DifferenceTooLong.super.identifier();
    }

    private ImmutableDifferenceTooLong(Builder builder) {
        this.pts = builder.pts;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DifferenceTooLong.super.identifier();
    }

    private ImmutableDifferenceTooLong(int identifier, int pts) {
        this.identifier = identifier;
        this.pts = pts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    public final ImmutableDifferenceTooLong withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDifferenceTooLong(value, this.pts);
    }

    public final ImmutableDifferenceTooLong withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableDifferenceTooLong(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDifferenceTooLong && this.equalTo(0, (ImmutableDifferenceTooLong)another);
    }

    private boolean equalTo(int synthetic, ImmutableDifferenceTooLong another) {
        return this.identifier == another.identifier && this.pts == another.pts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pts;
        return h;
    }

    public String toString() {
        return "DifferenceTooLong{identifier=" + this.identifier + ", pts=" + this.pts + "}";
    }

    public static ImmutableDifferenceTooLong of(int pts) {
        return new ImmutableDifferenceTooLong(pts);
    }

    public static ImmutableDifferenceTooLong copyOf(DifferenceTooLong instance) {
        if (instance instanceof ImmutableDifferenceTooLong) {
            return (ImmutableDifferenceTooLong)instance;
        }
        return ImmutableDifferenceTooLong.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int pts;

        private Builder() {
        }

        public final Builder from(DifferenceTooLong instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Difference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Difference instance;
            long bits = 0L;
            if (object instanceof DifferenceTooLong) {
                instance = (DifferenceTooLong)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Difference) {
                instance = (Difference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDifferenceTooLong build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDifferenceTooLong(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            return "Cannot build DifferenceTooLong, some of required attributes are not set " + attributes;
        }
    }
}

