/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.updates;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.updates.State;

public final class ImmutableState
implements State {
    private final int identifier;
    private final int pts;
    private final int qts;
    private final int date;
    private final int seq;
    private final int unreadCount;

    private ImmutableState(int pts, int qts, int date, int seq, int unreadCount) {
        this.pts = pts;
        this.qts = qts;
        this.date = date;
        this.seq = seq;
        this.unreadCount = unreadCount;
        this.identifier = State.super.identifier();
    }

    private ImmutableState(Builder builder) {
        this.pts = builder.pts;
        this.qts = builder.qts;
        this.date = builder.date;
        this.seq = builder.seq;
        this.unreadCount = builder.unreadCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : State.super.identifier();
    }

    private ImmutableState(int identifier, int pts, int qts, int date, int seq, int unreadCount) {
        this.identifier = identifier;
        this.pts = pts;
        this.qts = qts;
        this.date = date;
        this.seq = seq;
        this.unreadCount = unreadCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int seq() {
        return this.seq;
    }

    @Override
    public int unreadCount() {
        return this.unreadCount;
    }

    public final ImmutableState withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableState(value, this.pts, this.qts, this.date, this.seq, this.unreadCount);
    }

    public final ImmutableState withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableState(this.identifier, value, this.qts, this.date, this.seq, this.unreadCount);
    }

    public final ImmutableState withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableState(this.identifier, this.pts, value, this.date, this.seq, this.unreadCount);
    }

    public final ImmutableState withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableState(this.identifier, this.pts, this.qts, value, this.seq, this.unreadCount);
    }

    public final ImmutableState withSeq(int value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableState(this.identifier, this.pts, this.qts, this.date, value, this.unreadCount);
    }

    public final ImmutableState withUnreadCount(int value) {
        if (this.unreadCount == value) {
            return this;
        }
        return new ImmutableState(this.identifier, this.pts, this.qts, this.date, this.seq, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableState && this.equalTo(0, (ImmutableState)another);
    }

    private boolean equalTo(int synthetic, ImmutableState another) {
        return this.identifier == another.identifier && this.pts == another.pts && this.qts == another.qts && this.date == another.date && this.seq == another.seq && this.unreadCount == another.unreadCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.qts;
        h += (h << 5) + this.date;
        h += (h << 5) + this.seq;
        h += (h << 5) + this.unreadCount;
        return h;
    }

    public String toString() {
        return "State{identifier=" + this.identifier + ", pts=" + this.pts + ", qts=" + this.qts + ", date=" + this.date + ", seq=" + this.seq + ", unreadCount=" + this.unreadCount + "}";
    }

    public static ImmutableState of(int pts, int qts, int date, int seq, int unreadCount) {
        return new ImmutableState(pts, qts, date, seq, unreadCount);
    }

    public static ImmutableState copyOf(State instance) {
        if (instance instanceof ImmutableState) {
            return (ImmutableState)instance;
        }
        return ImmutableState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_QTS = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_SEQ = 8L;
        private static final long INIT_BIT_UNREAD_COUNT = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int pts;
        private int qts;
        private int date;
        private int seq;
        private int unreadCount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(State instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof State) {
                instance = (State)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.qts(instance.qts());
                this.unreadCount(instance.unreadCount());
                this.pts(instance.pts());
                this.seq(instance.seq());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder seq(int seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder unreadCount(int unreadCount) {
            this.unreadCount = unreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableState(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("qts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("seq");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("unreadCount");
            }
            return "Cannot build State, some of required attributes are not set " + attributes;
        }
    }
}

