/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.storage.FileType;
import telegram4j.tl.upload.BaseFile;
import telegram4j.tl.upload.File;

public final class ImmutableBaseFile
implements BaseFile {
    private final int identifier;
    private final FileType type;
    private final int mtime;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseFile(FileType type, int mtime) {
        this.type = Objects.requireNonNull(type, "type");
        this.mtime = mtime;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseFile(Builder builder) {
        this.type = builder.type;
        this.mtime = builder.mtime;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseFile(int identifier, FileType type, int mtime, ByteBuf bytes) {
        this.identifier = identifier;
        this.type = type;
        this.mtime = mtime;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseFile.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public FileType type() {
        return this.type;
    }

    @Override
    public int mtime() {
        return this.mtime;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutableBaseFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseFile(value, this.type, this.mtime, this.bytes);
    }

    public final ImmutableBaseFile withType(FileType value) {
        FileType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableBaseFile(this.identifier, newValue, this.mtime, this.bytes);
    }

    public final ImmutableBaseFile withMtime(int value) {
        if (this.mtime == value) {
            return this;
        }
        return new ImmutableBaseFile(this.identifier, this.type, value, this.bytes);
    }

    public ImmutableBaseFile withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutableBaseFile(this.identifier, this.type, this.mtime, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseFile && this.equalTo(0, (ImmutableBaseFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseFile another) {
        return this.identifier == another.identifier && this.type.equals((Object)another.type) && this.mtime == another.mtime && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.mtime;
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "BaseFile{identifier=" + this.identifier + ", type=" + this.type + ", mtime=" + this.mtime + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutableBaseFile of(FileType type, int mtime) {
        return new ImmutableBaseFile(type, mtime);
    }

    public static ImmutableBaseFile copyOf(BaseFile instance) {
        if (instance instanceof ImmutableBaseFile) {
            return (ImmutableBaseFile)instance;
        }
        return ImmutableBaseFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_MTIME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private FileType type;
        private int mtime;

        private Builder() {
        }

        public final Builder from(BaseFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(File instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            File instance;
            long bits = 0L;
            if (object instanceof BaseFile) {
                instance = (BaseFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.type(instance.type());
                this.mtime(instance.mtime());
                this.bytes(instance.bytes());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof File) {
                instance = (File)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(FileType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mtime(int mtime) {
            this.mtime = mtime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mtime");
            }
            return "Cannot build BaseFile, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseFile, attribute initializers form cycle " + attributes;
        }
    }
}

