/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.upload.CdnFile;
import telegram4j.tl.upload.CdnFileReuploadNeeded;

public final class ImmutableCdnFileReuploadNeeded
implements CdnFileReuploadNeeded {
    private final int identifier;
    private final ByteBuf requestToken;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCdnFileReuploadNeeded(Builder builder) {
        this.requestToken = builder.requestToken_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableCdnFileReuploadNeeded(int identifier, ByteBuf requestToken) {
        this.identifier = identifier;
        this.requestToken = requestToken;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CdnFileReuploadNeeded.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf requestToken() {
        return this.requestToken.duplicate();
    }

    public final ImmutableCdnFileReuploadNeeded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCdnFileReuploadNeeded(value, this.requestToken);
    }

    public ImmutableCdnFileReuploadNeeded withRequestToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.requestToken == newValue) {
            return this;
        }
        return new ImmutableCdnFileReuploadNeeded(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCdnFileReuploadNeeded && this.equalTo(0, (ImmutableCdnFileReuploadNeeded)another);
    }

    private boolean equalTo(int synthetic, ImmutableCdnFileReuploadNeeded another) {
        return this.identifier == another.identifier && this.requestToken().equals((Object)another.requestToken());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.requestToken().hashCode();
        return h;
    }

    public String toString() {
        return "CdnFileReuploadNeeded{identifier=" + this.identifier + ", requestToken=" + ByteBufUtil.hexDump((ByteBuf)this.requestToken) + "}";
    }

    public static ImmutableCdnFileReuploadNeeded copyOf(CdnFileReuploadNeeded instance) {
        if (instance instanceof ImmutableCdnFileReuploadNeeded) {
            return (ImmutableCdnFileReuploadNeeded)instance;
        }
        return ImmutableCdnFileReuploadNeeded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf requestToken_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(CdnFileReuploadNeeded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CdnFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CdnFile instance;
            long bits = 0L;
            if (object instanceof CdnFileReuploadNeeded) {
                instance = (CdnFileReuploadNeeded)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestToken(instance.requestToken());
            }
            if (object instanceof CdnFile) {
                instance = (CdnFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder requestToken(ByteBuf value) {
            this.requestToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableCdnFileReuploadNeeded build() {
            return new ImmutableCdnFileReuploadNeeded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf requestToken_build() {
            return Objects.requireNonNull(this.requestToken_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCdnFileReuploadNeeded.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build CdnFileReuploadNeeded, attribute initializers form cycle " + attributes;
        }
    }
}

