/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.FileHash;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.upload.File;
import telegram4j.tl.upload.FileCdnRedirect;

public final class ImmutableFileCdnRedirect
implements FileCdnRedirect {
    private final int identifier;
    private final int dcId;
    private final ByteBuf fileToken;
    private final ByteBuf encryptionKey;
    private final ByteBuf encryptionIv;
    private final List<FileHash> fileHashes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFileCdnRedirect(int dcId) {
        this.dcId = dcId;
        this.fileToken = null;
        this.encryptionKey = null;
        this.encryptionIv = null;
        this.fileHashes = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableFileCdnRedirect(Builder builder) {
        this.dcId = builder.dcId;
        this.fileToken = builder.fileToken_build();
        this.encryptionKey = builder.encryptionKey_build();
        this.encryptionIv = builder.encryptionIv_build();
        this.fileHashes = ImmutableFileCdnRedirect.createUnmodifiableList(true, builder.fileHashes);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableFileCdnRedirect(int identifier, int dcId, ByteBuf fileToken, ByteBuf encryptionKey, ByteBuf encryptionIv, List<FileHash> fileHashes) {
        this.identifier = identifier;
        this.dcId = dcId;
        this.fileToken = fileToken;
        this.encryptionKey = encryptionKey;
        this.encryptionIv = encryptionIv;
        this.fileHashes = fileHashes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return FileCdnRedirect.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public ByteBuf fileToken() {
        return this.fileToken.duplicate();
    }

    @Override
    public ByteBuf encryptionKey() {
        return this.encryptionKey.duplicate();
    }

    @Override
    public ByteBuf encryptionIv() {
        return this.encryptionIv.duplicate();
    }

    @Override
    public List<FileHash> fileHashes() {
        return this.fileHashes;
    }

    public final ImmutableFileCdnRedirect withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFileCdnRedirect(value, this.dcId, this.fileToken, this.encryptionKey, this.encryptionIv, this.fileHashes);
    }

    public final ImmutableFileCdnRedirect withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableFileCdnRedirect(this.identifier, value, this.fileToken, this.encryptionKey, this.encryptionIv, this.fileHashes);
    }

    public ImmutableFileCdnRedirect withFileToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileToken == newValue) {
            return this;
        }
        return new ImmutableFileCdnRedirect(this.identifier, this.dcId, newValue, this.encryptionKey, this.encryptionIv, this.fileHashes);
    }

    public ImmutableFileCdnRedirect withEncryptionKey(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.encryptionKey == newValue) {
            return this;
        }
        return new ImmutableFileCdnRedirect(this.identifier, this.dcId, this.fileToken, newValue, this.encryptionIv, this.fileHashes);
    }

    public ImmutableFileCdnRedirect withEncryptionIv(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.encryptionIv == newValue) {
            return this;
        }
        return new ImmutableFileCdnRedirect(this.identifier, this.dcId, this.fileToken, this.encryptionKey, newValue, this.fileHashes);
    }

    public final ImmutableFileCdnRedirect withFileHashes(FileHash ... elements) {
        List<FileHash> newValue = ImmutableFileCdnRedirect.createUnmodifiableList(false, ImmutableFileCdnRedirect.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFileCdnRedirect(this.identifier, this.dcId, this.fileToken, this.encryptionKey, this.encryptionIv, newValue);
    }

    public final ImmutableFileCdnRedirect withFileHashes(Iterable<? extends FileHash> elements) {
        if (this.fileHashes == elements) {
            return this;
        }
        List<FileHash> newValue = ImmutableFileCdnRedirect.createUnmodifiableList(false, ImmutableFileCdnRedirect.createSafeList(elements, true, false));
        return new ImmutableFileCdnRedirect(this.identifier, this.dcId, this.fileToken, this.encryptionKey, this.encryptionIv, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileCdnRedirect && this.equalTo(0, (ImmutableFileCdnRedirect)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileCdnRedirect another) {
        return this.identifier == another.identifier && this.dcId == another.dcId && this.fileToken().equals((Object)another.fileToken()) && this.encryptionKey().equals((Object)another.encryptionKey()) && this.encryptionIv().equals((Object)another.encryptionIv()) && this.fileHashes.equals(another.fileHashes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.fileToken().hashCode();
        h += (h << 5) + this.encryptionKey().hashCode();
        h += (h << 5) + this.encryptionIv().hashCode();
        h += (h << 5) + this.fileHashes.hashCode();
        return h;
    }

    public String toString() {
        return "FileCdnRedirect{identifier=" + this.identifier + ", dcId=" + this.dcId + ", fileToken=" + ByteBufUtil.hexDump((ByteBuf)this.fileToken) + ", encryptionKey=" + ByteBufUtil.hexDump((ByteBuf)this.encryptionKey) + ", encryptionIv=" + ByteBufUtil.hexDump((ByteBuf)this.encryptionIv) + ", fileHashes=" + this.fileHashes + "}";
    }

    public static ImmutableFileCdnRedirect of(int dcId) {
        return new ImmutableFileCdnRedirect(dcId);
    }

    public static ImmutableFileCdnRedirect copyOf(FileCdnRedirect instance) {
        if (instance instanceof ImmutableFileCdnRedirect) {
            return (ImmutableFileCdnRedirect)instance;
        }
        return ImmutableFileCdnRedirect.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf fileToken_value = null;
        private ByteBuf encryptionKey_value = null;
        private ByteBuf encryptionIv_value = null;
        private int identifier;
        private int dcId;
        private List<FileHash> fileHashes = new ArrayList<FileHash>();

        private Builder() {
        }

        public final Builder from(FileCdnRedirect instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(File instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            File instance;
            long bits = 0L;
            if (object instanceof FileCdnRedirect) {
                instance = (FileCdnRedirect)object;
                this.fileToken(instance.fileToken());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.encryptionIv(instance.encryptionIv());
                this.addAllFileHashes(instance.fileHashes());
                this.encryptionKey(instance.encryptionKey());
                this.dcId(instance.dcId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof File) {
                instance = (File)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder fileToken(ByteBuf value) {
            this.fileToken_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder encryptionKey(ByteBuf value) {
            this.encryptionKey_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder encryptionIv(ByteBuf value) {
            this.encryptionIv_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder addFileHashe(FileHash element) {
            this.fileHashes.add(Objects.requireNonNull(element, "fileHashes element"));
            return this;
        }

        public final Builder addFileHashes(FileHash ... elements) {
            for (FileHash element : elements) {
                this.fileHashes.add(Objects.requireNonNull(element, "fileHashes element"));
            }
            return this;
        }

        public final Builder fileHashes(Iterable<? extends FileHash> elements) {
            this.fileHashes.clear();
            return this.addAllFileHashes(elements);
        }

        public final Builder addAllFileHashes(Iterable<? extends FileHash> elements) {
            for (FileHash fileHash : elements) {
                this.fileHashes.add(Objects.requireNonNull(fileHash, "fileHashes element"));
            }
            return this;
        }

        public ImmutableFileCdnRedirect build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileCdnRedirect(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build FileCdnRedirect, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileToken_build() {
            return Objects.requireNonNull(this.fileToken_value);
        }

        private ByteBuf encryptionKey_build() {
            return Objects.requireNonNull(this.encryptionKey_value);
        }

        private ByteBuf encryptionIv_build() {
            return Objects.requireNonNull(this.encryptionIv_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableFileCdnRedirect.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build FileCdnRedirect, attribute initializers form cycle " + attributes;
        }
    }
}

