/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.storage.FileType;
import telegram4j.tl.upload.WebFile;

public final class ImmutableWebFile
implements WebFile {
    private final int identifier;
    private final int size;
    private final String mimeType;
    private final FileType fileType;
    private final int mtime;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebFile(int size, String mimeType, FileType fileType, int mtime) {
        this.size = size;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.fileType = Objects.requireNonNull(fileType, "fileType");
        this.mtime = mtime;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableWebFile(Builder builder) {
        this.size = builder.size;
        this.mimeType = builder.mimeType;
        this.fileType = builder.fileType;
        this.mtime = builder.mtime;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableWebFile(int identifier, int size, String mimeType, FileType fileType, int mtime, ByteBuf bytes) {
        this.identifier = identifier;
        this.size = size;
        this.mimeType = mimeType;
        this.fileType = fileType;
        this.mtime = mtime;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WebFile.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public FileType fileType() {
        return this.fileType;
    }

    @Override
    public int mtime() {
        return this.mtime;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutableWebFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWebFile(value, this.size, this.mimeType, this.fileType, this.mtime, this.bytes);
    }

    public final ImmutableWebFile withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableWebFile(this.identifier, value, this.mimeType, this.fileType, this.mtime, this.bytes);
    }

    public final ImmutableWebFile withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableWebFile(this.identifier, this.size, newValue, this.fileType, this.mtime, this.bytes);
    }

    public final ImmutableWebFile withFileType(FileType value) {
        FileType newValue = Objects.requireNonNull(value, "fileType");
        if (this.fileType == newValue) {
            return this;
        }
        return new ImmutableWebFile(this.identifier, this.size, this.mimeType, newValue, this.mtime, this.bytes);
    }

    public final ImmutableWebFile withMtime(int value) {
        if (this.mtime == value) {
            return this;
        }
        return new ImmutableWebFile(this.identifier, this.size, this.mimeType, this.fileType, value, this.bytes);
    }

    public ImmutableWebFile withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutableWebFile(this.identifier, this.size, this.mimeType, this.fileType, this.mtime, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebFile && this.equalTo(0, (ImmutableWebFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebFile another) {
        return this.identifier == another.identifier && this.size == another.size && this.mimeType.equals(another.mimeType) && this.fileType.equals((Object)another.fileType) && this.mtime == another.mtime && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.size;
        h += (h << 5) + this.mimeType.hashCode();
        h += (h << 5) + this.fileType.hashCode();
        h += (h << 5) + this.mtime;
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "WebFile{identifier=" + this.identifier + ", size=" + this.size + ", mimeType=" + this.mimeType + ", fileType=" + this.fileType + ", mtime=" + this.mtime + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutableWebFile of(int size, String mimeType, FileType fileType, int mtime) {
        return new ImmutableWebFile(size, mimeType, fileType, mtime);
    }

    public static ImmutableWebFile copyOf(WebFile instance) {
        if (instance instanceof ImmutableWebFile) {
            return (ImmutableWebFile)instance;
        }
        return ImmutableWebFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SIZE = 1L;
        private static final long INIT_BIT_MIME_TYPE = 2L;
        private static final long INIT_BIT_FILE_TYPE = 4L;
        private static final long INIT_BIT_MTIME = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private int size;
        private String mimeType;
        private FileType fileType;
        private int mtime;

        private Builder() {
        }

        public final Builder from(WebFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WebFile instance;
            long bits = 0L;
            if (object instanceof WebFile) {
                instance = (WebFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.mimeType(instance.mimeType());
                this.size(instance.size());
                this.mtime(instance.mtime());
                this.bytes(instance.bytes());
                this.fileType(instance.fileType());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fileType(FileType fileType) {
            this.fileType = Objects.requireNonNull(fileType, "fileType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder mtime(int mtime) {
            this.mtime = mtime;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableWebFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mimeType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fileType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mtime");
            }
            return "Cannot build WebFile, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWebFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build WebFile, attribute initializers form cycle " + attributes;
        }
    }
}

