/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.cli;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.cli.ProcessFailedException;
import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.cli.StringProcessResultConverterImpl;
import com.telenav.cactus.process.ProcessControl;
import com.telenav.cactus.process.ProcessResult;
import com.telenav.cactus.util.PathUtils;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public abstract class CliCommand<T>
implements Supplier<String> {
    private static final int MAX_LAUNCH_ATTEMPTS = 7;
    protected final String name;
    protected final ProcessResultConverter<T> resultCreator;

    public static <O, E> AwaitableCompletionStage<ProcessResult<O, E>> completionStageForProcess(ProcessControl<O, E> proc) {
        return AwaitableCompletionStage.of((CompletionStage)proc.onExit());
    }

    public static CliCommand<String> fixed(String command, Path workingDir, String ... fixedArgs) {
        return new SimpleCommand(command, workingDir, fixedArgs);
    }

    public CliCommand(String name, ProcessResultConverter<T> resultCreator) {
        this.name = name;
        this.resultCreator = resultCreator;
    }

    @Override
    public String get() {
        return this.toString();
    }

    protected ProcessResultConverter<T> resultConverter() {
        return this.resultCreator;
    }

    public AwaitableCompletionStage<T> run() {
        return AwaitableCompletionStage.from(() -> {
            ThrowingOptional<ProcessControl<String, String>> p = this.launch();
            if (!p.isPresent()) {
                return CompletableFuture.failedStage(new IOException("Could not find executable for " + this));
            }
            return this.resultConverter().onProcessStarted(this, (ProcessControl<String, String>)((ProcessControl)p.get()));
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        ArrayList<String> args = new ArrayList<String>();
        this.configureArguments(args);
        for (String arg : args) {
            sb.append(' ').append(arg);
        }
        this.workingDirectory().ifPresent(dir -> sb.append(" (in ").append(dir).append(')'));
        return sb.toString();
    }

    protected abstract void configureArguments(List<String> var1);

    protected void configureProcessBulder(NuProcessBuilder bldr, ProcessControl callback) {
    }

    protected ThrowingOptional<ProcessControl<String, String>> launch() {
        this.validate();
        return ThrowingOptional.from((Optional)PathUtils.findExecutable((String)this.name, (Path[])new Path[0])).map(path -> {
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(path.toString());
            this.configureArguments(commandLine);
            NuProcessBuilder pb = new NuProcessBuilder(commandLine);
            ProcessControl callback = ProcessControl.create((NuProcessBuilder)pb);
            this.internalConfigureProcessBuilder(pb, callback);
            NuProcess proc = pb.start();
            if (proc == null) {
                for (int i = 0; i < 7; ++i) {
                    System.out.println("Process launch failed for " + this + ". Retry " + (i + 1));
                    Thread.sleep(500L);
                    pb = new NuProcessBuilder(commandLine);
                    callback = ProcessControl.create((NuProcessBuilder)pb);
                    pb.environment().put("GIT_TERMINAL_PROMPT", "0");
                    this.internalConfigureProcessBuilder(pb, callback);
                    proc = pb.start();
                    if (proc == null) continue;
                    this.onLaunch((ProcessControl<String, String>)callback);
                    System.out.println("RETRY " + i + " succeeded.");
                    break;
                }
            } else {
                this.onLaunch((ProcessControl<String, String>)callback);
            }
            if (proc == null) {
                return ProcessControl.failure((Exception)new ProcessFailedException(() -> "Failed to launch " + this + " after 7 attempts", callback, "", ""));
            }
            return callback;
        });
    }

    protected void onLaunch(ProcessControl<String, String> proc) {
    }

    protected void validate() {
    }

    protected Optional<Path> workingDirectory() {
        return Optional.empty();
    }

    private void internalConfigureProcessBuilder(NuProcessBuilder bldr, ProcessControl callback) {
        this.workingDirectory().ifPresent(dir -> bldr.setCwd(dir));
        this.configureProcessBulder(bldr, callback);
    }

    static class SimpleCommand
    extends CliCommand<String> {
        private final Path workingDir;
        private final String[] fixedArgs;

        public SimpleCommand(String name, Path workingDir, String ... fixedArgs) {
            super(name, new StringProcessResultConverterImpl());
            this.workingDir = workingDir;
            this.fixedArgs = fixedArgs;
        }

        @Override
        protected void configureArguments(List<String> list) {
            list.addAll(Arrays.asList(this.fixedArgs));
        }

        @Override
        protected Optional<Path> workingDirectory() {
            return Optional.ofNullable(this.workingDir);
        }
    }
}

