/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.cli;

import com.telenav.cactus.process.ProcessControl;
import java.util.function.Supplier;

public final class ProcessFailedException
extends RuntimeException {
    public final ProcessControl process;
    public final String stdout;
    public final String stderr;
    public final String command;

    public ProcessFailedException(Supplier<String> supp, ProcessControl process, String stdout, String stderr) {
        this.process = process;
        this.stdout = stdout;
        this.stderr = stderr;
        this.command = supp.get();
    }

    @Override
    public String getMessage() {
        StringBuilder result = new StringBuilder(this.command);
        result.append(" exited ").append(this.process.exitValue());
        if (!this.stdout.isBlank()) {
            result.append('\n').append(this.stdout);
        }
        if (!this.stderr.isBlank()) {
            result.append('\n').append(this.stderr);
        }
        return result.toString();
    }
}

