/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.cli;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.process.ProcessControl;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface StringProcessResultConverter
extends ProcessResultConverter<String> {
    default public ProcessResultConverter<Boolean> trueIfEmpty() {
        return this.testedWith(String::isEmpty);
    }

    default public ProcessResultConverter<Boolean> testedWith(Predicate<String> predicate) {
        return this.map(text -> predicate.test((String)text));
    }

    default public ProcessResultConverter<List<String>> lines() {
        return this.trimmed().map(str -> str == null ? null : Arrays.asList(str.split("\n")));
    }

    default public StringProcessResultConverter trimmed() {
        return (description, proc) -> AwaitableCompletionStage.of((CompletionStage)this.onProcessStarted(description, (ProcessControl<String, String>)proc).thenApply(String::trim));
    }

    default public StringProcessResultConverter filter(Pattern pattern) {
        return (description, proc) -> {
            CompletableFuture result = new CompletableFuture();
            this.onProcessStarted(description, (ProcessControl<String, String>)proc).whenComplete((str, thrown) -> {
                if (thrown != null) {
                    result.completeExceptionally((Throwable)thrown);
                } else {
                    Matcher m = pattern.matcher((CharSequence)str);
                    if (!1.$assertionsDisabled && m.groupCount() != 1) {
                        throw new AssertionError();
                    }
                    if (m.find()) {
                        result.complete(m.group(1));
                    } else {
                        result.completeExceptionally(new IllegalStateException("Pattern " + pattern.pattern() + " not matched in '" + str + "'"));
                    }
                }
            });
            return AwaitableCompletionStage.of(result);
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

