/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.cli;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.telenav.cactus.cli.CliCommand;
import com.telenav.cactus.cli.ProcessFailedException;
import com.telenav.cactus.cli.StringProcessResultConverter;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.process.ProcessControl;
import java.util.function.IntPredicate;
import java.util.function.Supplier;

final class StringProcessResultConverterImpl
implements StringProcessResultConverter {
    final IntPredicate exitCodeTest;
    private final BuildLog log = BuildLog.get();

    public StringProcessResultConverterImpl(IntPredicate exitCodeTest) {
        this.exitCodeTest = exitCodeTest;
    }

    public StringProcessResultConverterImpl() {
        this(code -> code == 0);
    }

    @Override
    public AwaitableCompletionStage<String> onProcessStarted(Supplier<String> description, ProcessControl<String, String> process) {
        Exception launched = new Exception();
        return CliCommand.completionStageForProcess(process).thenApply(result -> {
            this.log.debug(() -> "exit " + result.exitValue() + ":\n" + (String)result.standardOutput() + "\n" + (result.exitValue() != 0 ? (String)result.standardError() : ""));
            if (this.exitCodeTest.test(result.exitValue())) {
                return (String)result.standardOutput();
            }
            ProcessFailedException ex = new ProcessFailedException(description, process, (String)result.standardOutput(), (String)result.standardError());
            ex.initCause(launched);
            throw ex;
        });
    }
}

