/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.cli;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.telenav.cactus.cli.BooleanProcessResultConverter;
import com.telenav.cactus.cli.StringProcessResultConverter;
import com.telenav.cactus.cli.StringProcessResultConverterImpl;
import com.telenav.cactus.process.ProcessControl;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;

public interface ProcessResultConverter<T> {
    public AwaitableCompletionStage<T> onProcessStarted(Supplier<String> var1, ProcessControl<String, String> var2);

    public static StringProcessResultConverter strings() {
        return new StringProcessResultConverterImpl();
    }

    public static StringProcessResultConverter strings(IntPredicate exitCodeTester) {
        return new StringProcessResultConverterImpl(exitCodeTester);
    }

    public static ProcessResultConverter<Optional<String>> nonEmptyString() {
        return ProcessResultConverter.strings().map(str -> str == null || str.isBlank() ? Optional.empty() : Optional.of(str.trim()));
    }

    public static ProcessResultConverter<Boolean> exitCodeIsZero() {
        return new BooleanProcessResultConverter();
    }

    public static ProcessResultConverter<Boolean> exitCode(IntPredicate pred) {
        return new BooleanProcessResultConverter(pred);
    }

    public static ProcessResultConverter<Integer> rawExitCode() {
        return (description, proc) -> AwaitableCompletionStage.of(proc.onExit().handle((p, thrown) -> thrown != null ? -1 : p.exitValue()));
    }

    public static ProcessResultConverter<URI> trailingUriWithTrailingDigitAloneOnLine() {
        return ProcessResultConverter.strings().map(processOutput -> {
            String[] lines = processOutput.split("\n");
            for (int i = lines.length - 1; i >= 0; --i) {
                String ln = lines[i].trim();
                if (!ln.startsWith("https://") || !Character.isDigit(ln.charAt(ln.length() - 1))) continue;
                return URI.create(ln);
            }
            throw new IllegalArgumentException("No URI found in process output \n'" + processOutput + "'");
        });
    }

    default public <R> ProcessResultConverter<R> map(Function<T, R> converter) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (description, proc) -> AwaitableCompletionStage.of((CompletionStage)this.onProcessStarted(description, (ProcessControl<String, String>)proc).thenApply(arg -> {
            Thread t = Thread.currentThread();
            ClassLoader old = t.getContextClassLoader();
            try {
                t.setContextClassLoader(classLoader);
                Object r = converter.apply(arg);
                return r;
            }
            finally {
                t.setContextClassLoader(old);
            }
        }));
    }
}

