/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.analysis;

import com.mastfrog.concurrent.ConcurrentLinkedList;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.analysis.ProjectScanConsumer;
import com.telenav.cactus.analysis.SourceScorer;
import com.telenav.cactus.analysis.SourcesScanner;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;

public final class MavenProjectsScanner {
    private final ConcurrentLinkedList<Pom> poms = ConcurrentLinkedList.lifo();
    private final BuildLog log;
    private final SourcesScanner scanner;
    private Function<Path, Path> sourceDirFinder;
    private boolean verbose;

    public MavenProjectsScanner(BuildLog log, SourceScorer scorer, Collection<? extends Pom> poms, boolean verbose) {
        this(log, scorer, poms, MavenProjectsScanner::defaultSourceDir, verbose);
        this.verbose = verbose;
    }

    public MavenProjectsScanner(BuildLog log, SourceScorer scorer, Collection<? extends Pom> poms, Function<Path, Path> sourceDirFinder, boolean verbose) {
        this.scanner = new SourcesScanner((SourceScorer)Checks.notNull((String)"scorer", (Object)scorer));
        this.sourceDirFinder = (Function)Checks.notNull((String)"sourceDirFinder", sourceDirFinder);
        this.verbose = verbose;
        this.log = log.child(this.getClass().getSimpleName());
        if (verbose) {
            this.log.info("Was passed " + poms.size() + " projects to scan: " + poms);
        }
        poms.stream().filter(pom -> !pom.isPomProject()).forEach(arg_0 -> this.poms.push(arg_0));
    }

    public void scan(ProjectScanConsumer c) throws InterruptedException, IOException {
        if (this.verbose) {
            this.log.info("Scan " + this.poms.size() + " projects using " + c);
        }
        int count = Runtime.getRuntime().availableProcessors();
        CountDownLatch latch = new CountDownLatch(count);
        ConcurrentHashMap.KeySetView scanned = ConcurrentHashMap.newKeySet();
        for (int i = 0; i < count - 1; ++i) {
            ForkJoinPool.commonPool().submit(() -> scanned.addAll(this.scanLoop(latch, c)));
        }
        scanned.addAll(this.scanLoop(latch, c));
        latch.await();
        c.onDone();
        if (this.verbose) {
            this.log.info("Scanned " + scanned.size() + " projects:");
            scanned.forEach(pom -> this.log.info("  * " + pom.artifactId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Pom> scanLoop(CountDownLatch latch, ProjectScanConsumer c) {
        HashSet<Pom> result = new HashSet<Pom>();
        try {
            Pom pom;
            while ((pom = (Pom)this.poms.pop()) != null) {
                this.scanOne(pom, c);
                result.add(pom);
            }
        }
        finally {
            latch.countDown();
        }
        return result;
    }

    private void scanOne(Pom pom, ProjectScanConsumer c) {
        try {
            Map<Path, Integer> scoreForSourceFileRelativePath = this.performScan(pom);
            if (scoreForSourceFileRelativePath != null) {
                c.onProjectScanned(pom, scoreForSourceFileRelativePath);
            } else {
                this.log.warn("Could not scan source dir for " + pom);
            }
        }
        catch (Error | Exception ex) {
            this.log.error("Exception scanning " + pom, ex);
        }
    }

    private Map<Path, Integer> performScan(Pom pom) throws Exception {
        Path sourceFolder = pom.projectFolder().resolve("src").resolve("main").resolve("java");
        if (!Files.exists(sourceFolder, new LinkOption[0]) || !Files.isDirectory(sourceFolder, new LinkOption[0])) {
            return null;
        }
        TreeMap<Path, Integer> result = new TreeMap<Path, Integer>();
        this.scanner.scan(sourceFolder, (path, score) -> result.put(sourceFolder.relativize((Path)path), (Integer)score));
        return result;
    }

    private static Path defaultSourceDir(Path projectDir) {
        return projectDir.resolve("src").resolve("main").resolve("java");
    }
}

