/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.analysis;

import com.telenav.cactus.analysis.SourceScorer;
import com.telenav.cactus.analysis.WordCount;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SourcesScanner {
    private final SourceScorer scorer;

    public SourcesScanner() {
        this(new WordCount());
    }

    public SourcesScanner(SourceScorer scorer) {
        this.scorer = scorer;
    }

    public int scan(Path sourceRoot, BiConsumer<Path, Integer> output) throws IOException {
        int result = 0;
        try (Stream<Path> files = Files.walk(sourceRoot, new FileVisitOption[0]).filter(SourcesScanner::isJavaFile);){
            for (Path path : files.collect(Collectors.toCollection(ArrayList::new))) {
                int score = this.scorer.score(path);
                output.accept(path, score);
                ++result;
            }
        }
        return result;
    }

    private static boolean isJavaFile(Path path) {
        return path.getFileName().toString().endsWith(".java") && !Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path);
    }
}

