/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.analysis;

import com.telenav.cactus.analysis.SourceScorer;
import java.nio.file.Path;

public class WordCount
implements SourceScorer.StringSourceScorer {
    @Override
    public int score(Path path, String lines) {
        int result = 0;
        for (String line : lines.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("//") || line.startsWith("/*")) continue;
            result += this.scoreLine(line);
        }
        return result;
    }

    private int scoreLine(String line) {
        Kind lastState = Kind.WHITESPACE;
        int result = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            Kind newState = Kind.get(c);
            if (lastState != newState && newState.isWord() && !lastState.isWord()) {
                ++result;
            }
            lastState = newState;
        }
        return result;
    }

    static enum Kind {
        WHITESPACE,
        WORD_CHAR,
        OTHER_CHAR;


        boolean isWord() {
            return this == WORD_CHAR;
        }

        boolean is(char c) {
            switch (this) {
                case WHITESPACE: {
                    return Character.isWhitespace(c);
                }
                case WORD_CHAR: {
                    return Character.isAlphabetic(c) || Character.isDigit(c) || c == '.' || c == '$';
                }
                case OTHER_CHAR: {
                    return !Character.isAlphabetic(c) && !Character.isDigit(c) && !Character.isWhitespace(c);
                }
            }
            throw new AssertionError((Object)this);
        }

        static Kind get(char ch) {
            if (WHITESPACE.is(ch)) {
                return WHITESPACE;
            }
            if (WORD_CHAR.is(ch)) {
                return WORD_CHAR;
            }
            return OTHER_CHAR;
        }
    }
}

