/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.analysis.codeflowers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class CodeflowersIndexGenerator {
    private final Path dir;

    public CodeflowersIndexGenerator(Path dir) {
        this.dir = dir;
    }

    public void generate(String title) throws IOException {
        this.generate(title, this.deriveOptionsFromFiles());
    }

    public void generate(String title, Set<String> ids) throws IOException {
        String result = CodeflowersIndexGenerator.template().replaceAll("__PROJECT__", title).replaceAll("__OPTIONS__", this.options(ids));
        if (!Files.exists(this.dir, new LinkOption[0])) {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        Files.write(this.dir.resolve("index.html"), result.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        this.unzipAssets();
    }

    private void unzipAssets() throws IOException {
        try (InputStream in = CodeflowersIndexGenerator.class.getResourceAsStream("cf.zip");){
            if (in == null) {
                throw new IOException("cf.zip not adjacent to " + CodeflowersIndexGenerator.class + " on classpath");
            }
            try (ZipInputStream zip = new ZipInputStream(in);){
                ZipEntry en;
                while ((en = zip.getNextEntry()) != null) {
                    Path dest;
                    if (en.isDirectory()) {
                        dest = this.dir.resolve(en.getName());
                        if (Files.exists(dest, new LinkOption[0])) continue;
                        Files.createDirectories(dest, new FileAttribute[0]);
                        continue;
                    }
                    dest = this.dir.resolve(en.getName());
                    if (!Files.exists(dest.getParent(), new LinkOption[0])) {
                        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zip, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private static String template() throws IOException {
        try (InputStream in = CodeflowersIndexGenerator.class.getResourceAsStream("index-template.html");){
            if (in == null) {
                throw new IOException("index-template.html not adjacent to " + CodeflowersIndexGenerator.class + " on classpath");
            }
            String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private String options(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            String friendlyName = CodeflowersIndexGenerator.friendlyName(id);
            sb.append("<option value='data/").append(id).append(".json'>").append(friendlyName).append("</option>");
        }
        return sb.toString();
    }

    private static String friendlyName(String name) {
        StringBuilder sb = new StringBuilder();
        for (String part : name.split("-")) {
            char[] c = part.toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Set<String> deriveOptionsFromFiles() throws IOException {
        HashSet wcFiles = new HashSet();
        HashSet jsonFiles = new HashSet();
        try (Stream<Path> allFiles = Files.list(this.dir);){
            allFiles.forEach(file -> {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    return;
                }
                if (CodeflowersIndexGenerator.isJsonFile(file)) {
                    jsonFiles.add(CodeflowersIndexGenerator.rawFileName(file));
                } else if (CodeflowersIndexGenerator.isWc(file)) {
                    wcFiles.add(CodeflowersIndexGenerator.rawFileName(file));
                }
            });
        }
        TreeSet<String> result = new TreeSet<String>(wcFiles);
        result.retainAll(jsonFiles);
        return result;
    }

    private static String rawFileName(Path file) {
        String fn = file.getFileName().toString();
        int ix = fn.lastIndexOf(46);
        if (ix < 0) {
            return fn;
        }
        return fn.substring(0, ix);
    }

    private static boolean isJsonFile(Path path) {
        return path.getFileName().toString().endsWith(".json");
    }

    private static boolean isWc(Path path) {
        return path.getFileName().toString().endsWith(".json");
    }
}

