/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.analysis.codeflowers;

import com.mastfrog.function.state.Int;
import com.telenav.cactus.analysis.ProjectScanConsumer;
import com.telenav.cactus.analysis.codeflowers.CodeflowersIndexGenerator;
import com.telenav.cactus.maven.model.Pom;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class CodeflowersJsonGenerator
implements ProjectScanConsumer {
    private final String title;
    private final Path outputDir;
    private final boolean whitespace;
    private final Set<String> artifactIds = ConcurrentHashMap.newKeySet();
    private final boolean pretend;

    public CodeflowersJsonGenerator(String title, Path outputDir, boolean whitespace, boolean pretend) {
        this.title = title;
        this.outputDir = outputDir;
        this.whitespace = whitespace;
        this.pretend = pretend;
    }

    @Override
    public void onDone() throws IOException {
        new CodeflowersIndexGenerator(this.outputDir.getParent()).generate(this.title, new TreeSet<String>(this.artifactIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onProjectScanned(Pom pom, Map<Path, Integer> scores) throws IOException {
        this.artifactIds.add(pom.artifactId().text());
        HFolder root = new HFolder();
        scores.forEach((path, score) -> {
            if (path.getParent() == null) {
                root.addFile(path.getFileName().toString(), (int)score);
                return;
            }
            root.findChildFolder(path.getParent(), 0).addFile(path.getFileName().toString(), (int)score);
        });
        String fnBase = pom.artifactId().text();
        if (!Files.exists(this.outputDir, new LinkOption[0])) {
            Class<CodeflowersJsonGenerator> clazz = CodeflowersJsonGenerator.class;
            // MONITORENTER : com.telenav.cactus.analysis.codeflowers.CodeflowersJsonGenerator.class
            if (!Files.exists(this.outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.outputDir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : clazz
        }
        Path jsonFile = this.outputDir.resolve(fnBase + ".json");
        Path wcFile = this.outputDir.resolve(fnBase + ".wc");
        if (!this.pretend) {
            try (OutputStream jsonOut = Files.newOutputStream(jsonFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                jsonOut.write(root.jsonify(0, new SB(this.whitespace)).toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        StringBuilder wc = new StringBuilder();
        Int total = Int.create();
        scores.forEach((path, score) -> {
            if (wc.length() > 0) {
                wc.append('\n');
            }
            total.increment(score.intValue());
            String txt = Integer.toString(score);
            for (int i = 0; i < 7 - txt.length(); ++i) {
                wc.append(' ');
            }
            wc.append(txt).append(' ').append(path);
        });
        wc.append('\n');
        String tot = total.toString();
        for (int i = 0; i < 7 - tot.length(); ++i) {
            wc.append(' ');
        }
        wc.append(tot).append(" total\n");
        if (this.pretend) return;
        try (OutputStream wcOut = Files.newOutputStream(wcFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            wcOut.write(wc.toString().getBytes(StandardCharsets.UTF_8));
            return;
        }
    }

    private static final class HFolder
    implements Comparable<HFolder> {
        private final Map<String, HFolder> childFolders = new TreeMap<String, HFolder>();
        private final String name;
        private final Map<String, Integer> childFileScores = new TreeMap<String, Integer>();
        private static final String NAME_PREFIX = "\"name\" : ";
        private static final String CHILDREN_PREFIX = "\"children\" : [";
        private static final String SIZE_PREFIX = "\"size\" : ";

        HFolder(String name) {
            this.name = name;
        }

        HFolder() {
            this("");
        }

        public String toString() {
            return this.jsonify(0, new SB(false)).toString();
        }

        SB jsonify(int depth, SB sb) {
            if (sb.length() > 0) {
                sb.newline();
            }
            sb.spaces(depth).append('{').newline();
            if (!this.name.isEmpty()) {
                sb.spaces(depth).append(NAME_PREFIX).quote(this.name);
            }
            if (!this.childFolders.isEmpty() || !this.childFileScores.isEmpty()) {
                Map.Entry<String, Comparable<Integer>> en;
                if (!this.name.isEmpty()) {
                    sb.append(',').newline();
                }
                sb.spaces(this.name.isEmpty() ? depth + 1 : depth).append(CHILDREN_PREFIX);
                Iterator<Map.Entry<String, Comparable<Integer>>> it = this.childFileScores.entrySet().iterator();
                while (it.hasNext()) {
                    en = it.next();
                    String child = en.getKey();
                    Integer score = en.getValue();
                    sb.newline().spaces(depth + 2).append("{");
                    sb.newline().spaces(depth + 3).append(NAME_PREFIX).quote(child).append(',');
                    sb.newline().spaces(depth + 3).append(SIZE_PREFIX).append(score);
                    sb.newline().spaces(depth + 2).append("}");
                    if (!it.hasNext() && this.childFolders.isEmpty()) continue;
                    sb.append(",");
                }
                it = this.childFolders.entrySet().iterator();
                while (it.hasNext()) {
                    en = it.next();
                    ((HFolder)en.getValue()).jsonify(depth + 1, sb);
                    if (!it.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(']');
            }
            sb.newline().spaces(depth).append('}');
            if (this.name.isEmpty()) {
                sb.sb.append('\n');
            }
            return sb;
        }

        void addFile(String filename, int score) {
            this.childFileScores.put(filename, score);
        }

        HFolder findChildFolder(Path folderPath, int nameIndex) {
            if (nameIndex >= folderPath.getNameCount()) {
                return this;
            }
            String nm = folderPath.getName(nameIndex).toString();
            HFolder result = this.childFolders.get(nm);
            if (result == null) {
                result = new HFolder(nm);
                this.childFolders.put(nm, result);
            }
            return result.findChildFolder(folderPath, nameIndex + 1);
        }

        @Override
        public int compareTo(HFolder o) {
            return this.name.compareTo(o.name);
        }
    }

    static class SB {
        private final StringBuilder sb = new StringBuilder();
        private final boolean whitespace;

        SB(boolean whitespace) {
            this.whitespace = whitespace;
        }

        SB() {
            this(true);
        }

        int length() {
            return this.sb.length();
        }

        public SB newline() {
            if (this.whitespace) {
                this.sb.append('\n');
            }
            return this;
        }

        public SB append(char c) {
            if (!this.whitespace && c == '\n') {
                return this;
            }
            this.sb.append(c);
            return this;
        }

        public SB append(String s) {
            if (!this.whitespace) {
                s = s.replaceAll("\n", "");
                s = s.replaceAll(" : ", ":");
            }
            this.sb.append(s);
            return this;
        }

        public SB append(Object o) {
            this.sb.append(o);
            return this;
        }

        public SB spaces(int count) {
            if (!this.whitespace) {
                return this;
            }
            char[] c = new char[count * 2];
            Arrays.fill(c, ' ');
            this.sb.append(c);
            return this;
        }

        public SB quote(String what) {
            this.sb.append('\"').append(what.replaceAll("\"", "\\\"")).append('\"');
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

