/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.telenav.cactus.git.Heads;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Branches {
    private final Branch currentBranch;
    private final Set<Branch> branches;

    public static Branches from(String output) {
        TreeSet<Branch> result = new TreeSet<Branch>();
        Branch currentBranch = null;
        for (String line : output.split("\n")) {
            boolean isCurrentBranch;
            if (line.isBlank()) continue;
            boolean bl = isCurrentBranch = line.charAt(0) == '*';
            if (line.startsWith("  ") || line.startsWith("* ")) {
                line = line.substring(2);
            }
            if (line.contains("->")) continue;
            String remote = null;
            if (line.startsWith("remotes/")) {
                String[] parts = line.split("/");
                remote = parts[1];
                StringBuilder remainder = new StringBuilder();
                for (int i = 2; i < parts.length; ++i) {
                    if (remainder.length() > 0) {
                        remainder.append('/');
                    }
                    remainder.append(parts[i]);
                }
                line = remainder.toString();
            }
            Branch branch = new Branch(line, remote);
            if (isCurrentBranch) {
                currentBranch = branch;
            }
            result.add(branch);
        }
        return new Branches(currentBranch, result);
    }

    private Branches(Branch currentBranch, Set<Branch> branches) {
        this.currentBranch = currentBranch;
        this.branches = branches;
    }

    public boolean contains(String name) {
        for (Branch branch : this.branches) {
            if (!name.equals(branch.name())) continue;
            return true;
        }
        return false;
    }

    public Optional<Branch> find(String name) {
        for (Branch branch : this.branches) {
            if (!name.equals(branch.name())) continue;
            return Optional.of(branch);
        }
        return Optional.empty();
    }

    public Optional<Branch> currentBranch() {
        return Optional.ofNullable(this.currentBranch);
    }

    public Optional<Branch> localOrRemoteBranch(String name) {
        return this.find(name, true).or(() -> this.find(name, false));
    }

    public Optional<Branch> find(String name, boolean local) {
        for (Branch branch : this.branches) {
            if (local != branch.isLocal() || !name.equals(branch.branchName) && !name.equals(branch.trackingName())) continue;
            return Optional.of(branch);
        }
        return Optional.empty();
    }

    public boolean hasRemoteForLocalOrLocalForRemote(Branch branch) {
        return this.opposite(branch).isPresent();
    }

    public Optional<Branch> localBranchFor(Heads.Head remoteHead) {
        Optional<Branch> remote = this.find(remoteHead.name(), false);
        return remote.flatMap(this::opposite);
    }

    public Set<Branch> localBranches() {
        return this.branches.stream().filter(Branch::isLocal).collect(Collectors.toCollection(TreeSet::new));
    }

    public Optional<Branch> opposite(Branch branch) {
        return this.find(branch.branchName, !branch.isLocal());
    }

    public Set<Branch> remoteBranches() {
        return this.branches.stream().filter(Branch::isRemote).collect(Collectors.toCollection(TreeSet::new));
    }

    public Map<Branch, Heads.Head> remoteHeadsForLocalBranches(Heads heads) {
        HashMap<Branch, Heads.Head> result = new HashMap<Branch, Heads.Head>();
        this.localBranches().forEach(branch -> this.opposite((Branch)branch).ifPresent(remoteBranch -> heads.findBranch(branch.branchName).ifPresent(head -> result.put((Branch)branch, (Heads.Head)head))));
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Branch branch : this.branches) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (this.currentBranch == branch) {
                sb.append("* ");
            } else {
                sb.append("  ");
            }
            sb.append(branch);
        }
        return sb.toString();
    }

    public static final class Branch
    implements Comparable<Branch> {
        private final String branchName;
        private final String remote;

        Branch(String branchName, String remote) {
            this.branchName = branchName;
            this.remote = remote;
        }

        @Override
        public int compareTo(Branch o) {
            int result = this.branchName.compareTo(o.branchName);
            if (result == 0) {
                result = this.remoteName().compareTo(o.remoteName());
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != Branch.class) {
                return false;
            }
            Branch b = (Branch)o;
            return this.branchName.equals(b.branchName) && Objects.equals(this.remote, b.remote);
        }

        public int hashCode() {
            return 41 * this.branchName.hashCode() + (this.remote == null ? 0 : this.remote.hashCode());
        }

        public boolean isLocal() {
            return this.remote == null;
        }

        public boolean isRemote() {
            return !this.isLocal();
        }

        public boolean isSameName(Branch other) {
            return this.branchName.equals(other.branchName);
        }

        public String name() {
            return this.branchName;
        }

        public Optional<String> remote() {
            return Optional.ofNullable(this.remote);
        }

        public String toString() {
            if (this.remote != null) {
                return "remotes/" + this.remote + "/" + this.branchName;
            }
            return this.branchName;
        }

        public String trackingName() {
            if (this.remote != null) {
                return this.remote + "/" + this.branchName;
            }
            return this.branchName;
        }

        private String remoteName() {
            return this.remote == null ? "" : this.remote;
        }
    }
}

