/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CommitInfo {
    private final String hash;
    private final Instant when;
    private final String author;
    private final String parent;
    private final Set<Path> paths;

    public CommitInfo(String hash, Instant when, String author, String parent, Set<Path> paths) {
        this.hash = hash;
        this.when = when;
        this.author = author;
        this.parent = parent;
        this.paths = paths;
    }

    public String info() {
        return this.when + " '" + this.author + "' " + this.hash;
    }

    public Set<Path> changedSubpaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public Instant when() {
        return this.when;
    }

    public String author() {
        return this.author;
    }

    public String parent() {
        return this.parent;
    }

    public String hash() {
        return this.hash;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public Optional<CommitInfo> javaSourceHistory() {
        return this.includeOnlyFileExtension(".java");
    }

    public Optional<CommitInfo> includeOnlyFileExtension(String ext) {
        Object extF = ext.startsWith(".") ? ext : "." + ext;
        return this.filter(file -> file.getFileName().toString().endsWith(ext));
    }

    public Optional<CommitInfo> filter(Predicate<Path> test) {
        Set nue = this.paths.stream().filter(test).collect(Collectors.toCollection(HashSet::new));
        if (nue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CommitInfo(this.hash, this.when, this.author, this.parent, nue));
    }

    public boolean contains(Path checkoutRelativePath) {
        for (Path p : this.paths) {
            if (!p.startsWith(checkoutRelativePath) && !p.equals(checkoutRelativePath)) continue;
            return true;
        }
        return false;
    }

    static boolean visit(String output, Predicate<CommitInfo> test) {
        boolean result = true;
        CommitInfo currentHistory = null;
        Predicate<CommitInfo> emitter = hist -> hist == null || hist.isEmpty() || test.test((CommitInfo)hist);
        for (String line : output.split("\n")) {
            if (line.isEmpty()) {
                if (!emitter.test(currentHistory)) {
                    currentHistory = null;
                    result = false;
                    break;
                }
                currentHistory = null;
                continue;
            }
            if (line.startsWith("@^@:")) {
                if (!emitter.test(currentHistory)) {
                    currentHistory = null;
                    result = false;
                    break;
                }
                String[] parts = (line = line.substring(4)).split(":::");
                if (parts.length != 4) continue;
                String hash = parts[0];
                OffsetDateTime odt = OffsetDateTime.parse(parts[1]);
                String author = parts[2];
                String parentHash = parts[3];
                currentHistory = new CommitInfo(hash, odt.toInstant(), author, parentHash, new HashSet<Path>());
                continue;
            }
            if (currentHistory == null) {
                throw new IllegalArgumentException("Not a header or a path: '" + line + "'");
            }
            currentHistory.paths.add(Paths.get(line.trim(), new String[0]));
        }
        if (result && currentHistory != null && !currentHistory.isEmpty()) {
            result = test.test(currentHistory);
        }
        return result;
    }

    public String toString() {
        return "CommitInfo{hash=" + this.hash + ", when=" + this.when + ", author=" + this.author + ", parent=" + this.parent + ", paths=" + this.paths + "}";
    }
}

