/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.telenav.cactus.git.GitCheckout;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public final class Conflicts
implements Iterable<Conflict> {
    private final List<Conflict> conflicts;
    public static final Conflicts EMPTY = new Conflicts(Collections.emptyList());

    private Conflicts(List<Conflict> conflicts) {
        this.conflicts = conflicts;
    }

    public boolean isGitmodulesOnlyConflict() {
        return !this.isEmpty() && Collections.singleton(Paths.get(".gitmodules", new String[0])).equals(this.allPaths());
    }

    public Set<Path> allPaths() {
        HashSet<Path> result = new HashSet<Path>();
        for (Conflict cf : this) {
            result.addAll(cf.relativePaths());
        }
        return result;
    }

    public boolean hasHardConflicts() {
        if (this.isEmpty()) {
            return false;
        }
        for (Conflict c : this) {
            if (!c.isHardConflict()) continue;
            return true;
        }
        return false;
    }

    public Conflicts filterHard() {
        ArrayList<Conflict> result = new ArrayList<Conflict>();
        for (Conflict cf : this) {
            if (!cf.isHardConflict()) continue;
            result.add(cf);
        }
        return result.equals(this.conflicts) ? this : (result.isEmpty() ? EMPTY : new Conflicts(result));
    }

    public boolean isEmpty() {
        return this.conflicts.isEmpty();
    }

    @Override
    public Iterator<Conflict> iterator() {
        return Collections.unmodifiableList(this.conflicts).iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Conflict cf : this) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(cf);
        }
        return sb.toString();
    }

    public static Conflicts parse(String mergeTreeOutput) {
        if (mergeTreeOutput.trim().isEmpty()) {
            return EMPTY;
        }
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        boolean expectingChange = false;
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
        Runnable emitChangeInfos = () -> {
            if (!changeInfos.isEmpty()) {
                conflicts.add(new Conflict(changeInfos));
                changeInfos.clear();
            }
        };
        Runnable markLastAsDefiniteConflict = () -> {
            if (!conflicts.isEmpty()) {
                Conflict cf = (Conflict)conflicts.get(conflicts.size() - 1);
                cf.definiteConflict = true;
            }
        };
        for (String line : mergeTreeOutput.split("\n")) {
            if (line.startsWith("+<<<<<<<") || line.startsWith("+>>>>>>>") || line.startsWith("+=======")) {
                markLastAsDefiniteConflict.run();
                continue;
            }
            if (line.isBlank()) continue;
            if (expectingChange) {
                ChangeInfo info = ChangeInfo.parse(line);
                if (info == null) {
                    emitChangeInfos.run();
                    expectingChange = false;
                    continue;
                }
                changeInfos.add(info);
                continue;
            }
            if (!"changed in both".equals(line)) continue;
            emitChangeInfos.run();
            expectingChange = true;
        }
        emitChangeInfos.run();
        return conflicts.isEmpty() ? EMPTY : new Conflicts(conflicts);
    }

    public static final class Conflict
    implements Iterable<ChangeInfo> {
        private final List<ChangeInfo> between;
        boolean definiteConflict;

        Conflict(List<ChangeInfo> between) {
            this.between = new ArrayList<ChangeInfo>(between);
        }

        public Set<Path> relativePaths() {
            TreeSet<Path> result = new TreeSet<Path>();
            for (ChangeInfo info : this) {
                if (info.relativePath == null || info.relativePath.isBlank()) continue;
                result.add(Paths.get(info.relativePath, new String[0]));
            }
            return result;
        }

        public Optional<ChangeInfo> local() {
            return this.get("our");
        }

        public Optional<ChangeInfo> remote() {
            return this.get("their");
        }

        public Optional<ChangeInfo> base() {
            return this.get("base");
        }

        public Optional<ChangeInfo> get(String in) {
            for (ChangeInfo ci : this) {
                if (!in.equals(ci.in)) continue;
                return Optional.of(ci);
            }
            return Optional.empty();
        }

        public boolean isHardConflict() {
            return this.definiteConflict;
        }

        @Override
        public Iterator<ChangeInfo> iterator() {
            return Collections.unmodifiableList(this.between).iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("changed in both");
            for (ChangeInfo info : this) {
                sb.append('\n').append(info);
            }
            return sb.toString();
        }
    }

    public static final class ChangeInfo {
        public final int fileMode;
        public final String in;
        public final String commit;
        public final String relativePath;

        public ChangeInfo(int fileMode, String in, String commit, String relativePath) {
            this.fileMode = fileMode;
            this.in = in;
            this.commit = commit;
            this.relativePath = relativePath;
        }

        public boolean isDeleted() {
            return this.relativePath != null && "/dev/null".equals(this.relativePath);
        }

        public String toString() {
            return "  " + this.in + " " + this.fileMode + " " + this.commit + " " + this.relativePath;
        }

        public static final ChangeInfo parse(String line) {
            int perms;
            if (!line.startsWith("  ")) {
                return null;
            }
            String[] words = line.trim().split("\\s+");
            if (words.length < 4) {
                return null;
            }
            switch (words[0]) {
                case "base": 
                case "our": 
                case "their": {
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                perms = Integer.parseInt(words[1]);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            String hash = words[2];
            if (!GitCheckout.isGitCommitId(hash)) {
                return null;
            }
            Object relPath = words[3];
            if (words.length > 3) {
                for (int i = 4; i < words.length; ++i) {
                    relPath = (String)relPath + " " + words[i];
                }
            }
            ChangeInfo result = new ChangeInfo(perms, words[0], hash, (String)relPath);
            return result;
        }
    }
}

