/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.cli.CliCommand;
import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.process.ProcessControl;
import com.zaxxer.nuprocess.NuProcessBuilder;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class GitCommand<T>
extends CliCommand<T> {
    private final Path workingDir;
    private final String[] args;
    private final BuildLog log = BuildLog.get().child(((Object)((Object)this)).getClass().getSimpleName());

    public GitCommand(ProcessResultConverter<T> resultCreator, String ... args) {
        this(resultCreator, (Path)null, args);
    }

    public GitCommand(ProcessResultConverter<T> resultCreator, Path workingDir, String ... args) {
        super("git", resultCreator);
        this.workingDir = workingDir;
        this.args = (String[])Checks.notNull((String)"args", (Object)args);
    }

    public GitCommand<T> withWorkingDir(Path dir) {
        return new GitCommand<T>(this.resultCreator, dir, this.args);
    }

    protected Optional<Path> workingDirectory() {
        return Optional.ofNullable(this.workingDir);
    }

    protected void onLaunch(ProcessControl<String, String> proc) {
        this.log.debug(() -> "started: " + this);
        super.onLaunch(proc);
        proc.killAfter(Duration.ofMinutes(10L));
    }

    protected void configureProcessBulder(NuProcessBuilder bldr, ProcessControl callback) {
        bldr.environment().put("GIT_PAGER", "/bin/cat");
        bldr.environment().put("GIT_ASKPASS", "/usr/bin/false");
        bldr.environment().put("GIT_CONFIG_NOSYSTEM", "1");
        bldr.environment().put("GIT_TERMINAL_PROMPT", "0");
    }

    protected void validate() {
        if (this.workingDir == null) {
            throw new IllegalStateException("Command is a template. Use withWorkingDir() to get an instance that has somewhere to run.");
        }
    }

    protected void configureArguments(List<String> list) {
        list.add("--no-pager");
        list.add("-c");
        list.add("push.default=current");
        list.add("-c");
        list.add("pull.rebase=false");
        list.add("-c");
        list.add("diff.renamelimit=0");
        list.add("-c");
        list.add("init.defaultBranch=main");
        list.addAll(Arrays.asList(this.args));
    }
}

