/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.git;

import com.telenav.cactus.maven.log.BuildLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GitRemotes {
    public final String name;
    public final String pushUrl;
    public final String fetchUrl;

    static Map<String, GitRemotes> from(String output) {
        HashMap<String, String> pushUrls = new HashMap<String, String>();
        HashMap<String, String> fetchUrls = new HashMap<String, String>();
        block8: for (String line : output.split("\n")) {
            String[] parts = line.split("\\s+");
            if (parts.length != 3) continue;
            switch (parts[2]) {
                case "(push)": {
                    pushUrls.put(parts[0], parts[1]);
                    continue block8;
                }
                case "(fetch)": {
                    fetchUrls.put(parts[0], parts[1]);
                    continue block8;
                }
                default: {
                    BuildLog.get().child("git-remotes").warn("Unrecognized output from `git remote -v`: " + line);
                }
            }
        }
        HashMap<String, GitRemotes> result = new HashMap<String, GitRemotes>();
        pushUrls.forEach((name, pushUrl) -> {
            String fetchUrl = (String)fetchUrls.get(name);
            if (fetchUrl != null) {
                GitRemotes remotes = new GitRemotes((String)name, (String)pushUrl, fetchUrl);
                result.put((String)name, remotes);
            }
        });
        return result;
    }

    public GitRemotes(String name, String pushUrl, String fetchUrl) {
        this.name = name;
        this.pushUrl = pushUrl;
        this.fetchUrl = fetchUrl;
    }

    public void collectRemoteNames(Set<? super String> into) {
        GitRemotes.collectRemoteNames(this.pushUrl, into);
        GitRemotes.collectRemoteNames(this.fetchUrl, into);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name + " " + this.fetchUrl + " (fetch)\n" + this.name + " " + this.pushUrl + " (push)";
    }

    private static void collectRemoteNames(String remoteUrl, Set<? super String> into) {
        String[] urlParts = remoteUrl.split("[/:]");
        String last = urlParts[urlParts.length - 1];
        if (last.endsWith(".git")) {
            last = last.substring(0, last.length() - 4);
        }
        into.add(last);
    }
}

